<?php

namespace App\Http\Controllers;

use App\Models\Banksum;
use App\Models\Branch;
use App\Models\Client;
use App\Models\Code;
use App\Models\Curbatch;
use App\Models\Dompojb;
use App\Models\EID;
use App\Models\Newone;
use App\Models\Patient;
use App\Models\PatientType;
use App\Models\PaymentType;
use App\Models\Stktra;
use App\Models\Stock;
use App\Models\SubTransactionType;
use App\Models\Supplier;
use App\Models\Till;
use App\Models\TopCustomer;
use App\Models\TransactionType;
use App\Models\Trovan;
use App\Models\Type;
use App\Models\User;
use App\Models\UserType;
use App\Models\Vetcons;
use App\Models\Vetuser;
use App\Models\Warehouse;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Str;

class Report2Controller extends Controller
{
    public function newClients()
    {
        $branches = Branch::where('id', '!=', null)
            ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();

        return view('reports.NewClients', compact('branches'));
    }
    public function newClientsReport(Request $request)
    {
        $runDate = Carbon::now();
        $start_date = Carbon::createFromFormat('Y-m-d', $request->start_date);
        $end_date = Carbon::createFromFormat('Y-m-d', $request->end_date);
        $report = null;
        if ($request->end_date <= $request->start_date)
            return Redirect::route('NewClients')->withInput()->with('danger', 'Start Date cannot be greater than End Date');

        if (
            $request->show_byDay == null && $request->show_byWeek == null && $request->show_byMonth == null &&
            $request->show_byYear == null
        )
            return Redirect::route('NewClients')->withInput()->with('danger', 'At least one show by must be checked');

        if ($request->show_byDay == 'on') {
            if ($request->show_byWeek == 'on' or $request->show_byMonth == 'on' or $request->show_byYear == 'on')
                return Redirect::route('NewClients')->withInput()->with('danger', 'You cannot check multiple show by"s at the same time');
            $report = 'Day';
        }
        if ($request->show_byWeek == 'on') {
            if ($request->show_byDay == 'on' or $request->show_byMonth == 'on' or $request->show_byYear == 'on')
                return Redirect::route('NewClients')->withInput()->with('danger', 'You cannot check multiple show by"s at the same time');
            $report = 'Week';
        }
        if ($request->show_byMonth == 'on') {
            if ($request->show_byDay == 'on' or $request->show_byWeek == 'on' or $request->show_byYear == 'on')
                return Redirect::route('NewClients')->withInput()->with('danger', 'You cannot check multiple show by"s at the same time');
            $report = 'Month';
        }
        if ($request->show_byYear == 'on') {
            if ($request->show_byDay == 'on' or $request->show_byWeek == 'on' or $request->show_byMonth == 'on')
                return Redirect::route('NewClients')->withInput()->with('danger', 'You cannot check multiple show by"s at the same time');
            $report = 'Year';
        }
        if ($request->show_byWeek == 'on') {
            $diff = $end_date->diffInDays($start_date);
            if ($diff < 7)
                return Redirect::route('NewClients')->withInput()->with('danger', 'Difference in date is less than 7 days');
        }
        if ($request->show_byMonth == 'on') {
            $diff = $end_date->diffInDays($start_date);
            if ($diff < 31)
                return Redirect::route('NewClients')->withInput()->with('danger', 'Difference in date is less than 31 days');
        }
        if ($request->show_byYear == 'on') {
            $diff = $end_date->diffInDays($start_date);
            if ($diff < 365)
                return Redirect::route('NewClients')->withInput()->with('danger', 'Difference in date is less than 365 days');
        }
        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();
        $eid = EID::find($user->eid_id);
        $name = $eid->schemaName;
        DB::table($name . '.' . 'newones')->truncate();

        if ($request->branch_id == null) {
            $patients = Patient::where('takeon_date', '>=', $request->start_date)
                ->where('takeon_date', '<=', $request->end_date)->get();
            $clients = Client::where('takeon_date', '>=', $request->start_date)
                ->where('takeon_date', '<=', $request->end_date)->get();
            $branch_name = 'All Branches';
        } else {
            $patients = Patient::where('branch_id', '=', $request->branch_id)
                ->where('takeon_date', '>=', $request->start_date)
                ->where('takeon_date', '<=', $request->end_date)->get();
            $clients = Client::where('branch_id', '=', $request->branch_id)
                ->where('takeon_date', '>=', $request->start_date)
                ->where('takeon_date', '<=', $request->end_date)->get();
            $branch = Branch::where('id', '=', $request->branch_id)->first();
            $branch_name = $branch->description;
        }
        foreach ($clients as $client) {
            if ($request->branch_id != null && $client->branch_id != $request->branch_id)
                continue;
            if ($client->takeon_date == null)
                continue;

            $newone = Newone::where('new_date', '=', $client->takeon_date)->first();
            if ($newone) {
                $newone->customer = $newone->customer + 1;
                $newone->update();
            } else {
                $newOnes = new Newone();
                $newOnes->new_date = $client->takeon_date;
                $newOnes->customer = 1;
                $newOnes->patient = 0;
                $newOnes->save();
                $newOnes->customer = $newOnes->customer + 1;
            }
        }
        foreach ($patients as $patient) {
            if ($request->branch_id != null && $patient->branch_id != $request->branch_id)
                continue;
            if ($patient->takeon_date == null)
                continue;

            $newone = Newone::where('new_date', '=', $patient->takeon_date)->first();
            if ($newone) {
                $newone->patient = $newone->patient + 1;
                $newone->update();
            } else {
                $newOnes = new Newone();
                $newOnes->new_date = $patient->takeon_date;
                $newOnes->customer = 0;
                $newOnes->patient = 1;
                $newOnes->save();
                $newOnes->patient = $newOnes->patient + 1;
            }
        }
        $newClient = array();
        $totNewClients = 0;
        $totNewPatients = 0;
        $aveClient = 0;
        $avePatient = 0;
        $last_date = null;
        $new_date = $request->start_date;
        if ($request->show_byDay == 'on') {
            $newOnes = Newone::where('new_date', '>=', $request->start_date)
                ->where('new_date', '<=', $request->end_date)->orderby('new_date', 'asc')->get();

            foreach ($newOnes as $newOne) {
                $newClients = new NewClients();
                $newClients->day = Carbon::parse($newOne->new_date)->format('l');
                $newClients->date = Carbon::parse($newOne->new_date)->format('d/m/Y');
                $newClients->clientsCount = $newOne->customer;
                $newClients->patientsCount = $newOne->patient;
                $totNewClients = $totNewClients + $newOne->customer;
                $totNewPatients = $totNewPatients + $newOne->patient;
                $aveClient = $aveClient + 1;
                $avePatient = $avePatient + 1;
                array_push($newClient, $newClients);
            }
        } elseif ($request->show_byWeek == 'on') {
            while ($last_date < $request->end_date) {
                $date = Carbon::parse($new_date)->addDays(7);
                $last_date = $date;

                if ($new_date != $request->start_date)
                    $begin_date = Carbon::parse($new_date)->addDay(1);
                else
                    $begin_date = $new_date;

                if ($last_date > $request->end_date) {
                    $last_date = $request->end_date;
                }
                $newCustomers = Newone::where('new_date', '>=', $begin_date)
                    ->where('new_date', '<=', $last_date)->count('customer');
                $newPatients = Newone::where('new_date', '>=', $begin_date)
                    ->where('new_date', '<=', $last_date)->count('patient');

                $newClients = new NewClients();
                $newClients->day = Carbon::parse($last_date)->format('l');
                $newClients->date = Carbon::parse($last_date)->format('d/m/Y');
                $newClients->clientsCount = $newCustomers;
                $newClients->patientsCount = $newPatients;
                $totNewClients = $totNewClients + $newCustomers;
                $totNewPatients = $totNewPatients + $newPatients;
                $aveClient = $aveClient + 1;
                $avePatient = $avePatient + 1;
                array_push($newClient, $newClients);
                $new_date = $date;
            }
        } elseif ($request->show_byMonth == 'on') {
            while ($last_date < $request->end_date) {
                $date = Carbon::parse($new_date)->addDays(31);
                $last_date = $date;

                $newCustomers = Newone::where('new_date', '>=', $new_date)
                    ->where('new_date', '<=', $last_date)->count('customer');
                $newPatients = Newone::where('new_date', '>=', $new_date)
                    ->where('new_date', '<=', $last_date)->count('patient');

                $newClients = new NewClients();
                $newClients->day = Carbon::parse($last_date)->format('l');
                $newClients->date = Carbon::parse($last_date)->format('d/m/Y');
                $newClients->clientsCount = $newCustomers;
                $newClients->patientsCount = $newPatients;
                $totNewClients = $totNewClients + $newCustomers;
                $totNewPatients = $totNewPatients + $newPatients;
                $aveClient = $aveClient + 1;
                $avePatient = $avePatient + 1;
                array_push($newClient, $newClients);
                $date = Carbon::parse($new_date)->addDays(32);
                $new_date = $date;
            }
        } elseif ($request->show_byYear == 'on') {
            while ($last_date < $request->end_date) {
                $date = Carbon::parse($new_date)->addDays(365);
                $last_date = $date;

                $newCustomers = Newone::where('new_date', '>=', $new_date)
                    ->where('new_date', '<=', $last_date)->count('customer');
                $newPatients = Newone::where('new_date', '>=', $new_date)
                    ->where('new_date', '<=', $last_date)->count('patient');

                $newClients = new NewClients();
                $newClients->day = Carbon::parse($last_date)->format('l');
                $newClients->date = Carbon::parse($last_date)->format('d/m/Y');
                $newClients->clientsCount = $newCustomers;
                $newClients->patientsCount = $newPatients;
                $totNewClients = $totNewClients + $newCustomers;
                $totNewPatients = $totNewPatients + $newPatients;
                $aveClient = $aveClient + 1;
                $avePatient = $avePatient + 1;
                array_push($newClient, $newClients);
                $date = Carbon::parse($new_date)->addDays(366);
                $new_date = $date;
            }
        }
        // calculate average
        $newClients = new NewClients();
        $newClients->day = 'Average:';
        $newClients->date = null;
        if ($aveClient > 0)
            $clientAverage = $totNewClients / $aveClient;
        else
            $clientAverage = 0;
        if ($avePatient > 0)
            $patientAverage = $totNewPatients / $avePatient;
        else
            $patientAverage = 0;

        return view('reports.NewClientReport', compact(
            'eid',
            'runDate',
            'start_date',
            'end_date',
            'branch_name',
            'report',
            'newClient',
            'totNewClients',
            'totNewPatients',
            'clientAverage',
            'patientAverage'
        ));
    }
    public function debtorsAge()
    {
        $branches = Branch::where('id', '!=', null)
            ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();

        return view('reports.DebtorsAge', compact('branches'));
    }
    public function debtorsAgeAnalysis(Request $request)
    {
        if ($request->bad_type == null) {
            if ($request->bad_debtors == 'on' or $request->handed_over == 'on' or $request->written_off == 'on')
                return Redirect::route('DebtorsAge')->withInput()->with(
                    'danger',
                    'Bad Debtors, Handed Over or Written Off cannot be marked "Y" when Bad-Type Flagged is marked "N"'
                );
        }
        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();
        $eid = EID::find($user->eid_id);

        if ($request->branch_id == null)
            $branch_name = 'All Branches';
        else {
            $branch = Branch::find($request->branch_id);
            $branch_name = $branch->description;
        }
        switch ($request->debtor_age) {
            case 0;
                $heading = "DEBTORS AGED ANALYSIS - 0 DAYS AND OVER";
                break;
            case 1;
                $heading = "DEBTORS AGED ANALYSIS - 30 DAYS AND OVER";
                break;
            case 2;
                $heading = "DEBTORS AGED ANALYSIS - 60 DAYS AND OVER";
                break;
            case 3;
                $heading = "DEBTORS AGED ANALYSIS - 90 DAYS AND OVER";
                break;
            case 4;
                $heading = "DEBTORS AGED ANALYSIS - 120 DAYS AND OVER";
                break;
            case 5;
                $heading = "DEBTORS AGED ANALYSIS - CREDIT BALANCE";
                break;
        }
        if ($request->bad_debtors == null)
            $badDebtorsNote = 'Note : Report contains no Bad Debtors';
        else
            $badDebtorsNote = null;

        if ($request->debtor_age == 0 && $request->credit_balances == 'on')
            $debtorAgeNote = 'Note: Report ALSO includes credit balances';
        else
            $debtorAgeNote = null;

        $date = Carbon::now();
        $clients = Client::where('customer', '!=', null)->get();
        if ($request->clients_telNo == 'on')
            $addTelNo = 'Yes';
        else
            $addTelNo = 'No';

        $curTot = 0;
        $age30Tot = 0;
        $age60Tot = 0;
        $age90Tot = 0;
        $age120Tot = 0;
        $grand_total = 0;
        $debAge = $request->debtor_age;
        $credBal = $request->credit_balances;
        $debtorAge = array();
        foreach ($clients as $client) {
            if ($request->bad_type == null) {
                if ($client->bad_dr == 'Y' or $client->bad_dr == 'B' or $client->bad_dr == 'H' or $client->bad_dr == 'W')
                    continue;
                if ($request->branch_id == null)
                    $this->editArray(
                        $debtorAge,
                        $client,
                        $debAge,
                        $credBal,
                        $curTot,
                        $age30Tot,
                        $age60Tot,
                        $age90Tot,
                        $age120Tot,
                        $grand_total
                    );
                elseif ($request->branch_id == $client->branch_id)
                    $this->editArray(
                        $debtorAge,
                        $client,
                        $debAge,
                        $credBal,
                        $curTot,
                        $age30Tot,
                        $age60Tot,
                        $age90Tot,
                        $age120Tot,
                        $grand_total
                    );
            } else {
                if ($client->bad_dr == 'Y' or $client->bad_dr == 'B' or $client->bad_dr == 'H' or $client->bad_dr == 'W') {
                    if ($client->bad_dr == 'Y' && $request->bad_debtors == 'on') {
                        if ($request->branch_id == null)
                            $this->editArray(
                                $debtorAge,
                                $client,
                                $debAge,
                                $credBal,
                                $curTot,
                                $age30Tot,
                                $age60Tot,
                                $age90Tot,
                                $age120Tot,
                                $grand_total
                            );
                        elseif ($request->branch_id == $client->branch_id)
                            $this->editArray(
                                $debtorAge,
                                $client,
                                $debAge,
                                $credBal,
                                $curTot,
                                $age30Tot,
                                $age60Tot,
                                $age90Tot,
                                $age120Tot,
                                $grand_total
                            );
                    }
                    if ($client->bad_dr == 'B' && $request->bad_debtors == 'on') {
                        if ($request->branch_id == null)
                            $this->editArray(
                                $debtorAge,
                                $client,
                                $debAge,
                                $credBal,
                                $curTot,
                                $age30Tot,
                                $age60Tot,
                                $age90Tot,
                                $age120Tot,
                                $grand_total
                            );
                        elseif ($request->branch_id == $client->branch_id)
                            $this->editArray(
                                $debtorAge,
                                $client,
                                $debAge,
                                $credBal,
                                $curTot,
                                $age30Tot,
                                $age60Tot,
                                $age90Tot,
                                $age120Tot,
                                $grand_total
                            );
                    }
                    if ($client->bad_dr == 'H' && $request->handed_over == 'on') {
                        if ($request->branch_id == null)
                            $this->editArray(
                                $debtorAge,
                                $client,
                                $debAge,
                                $credBal,
                                $curTot,
                                $age30Tot,
                                $age60Tot,
                                $age90Tot,
                                $age120Tot,
                                $grand_total
                            );
                        elseif ($request->branch_id == $client->branch_id)
                            $this->editArray(
                                $debtorAge,
                                $client,
                                $debAge,
                                $credBal,
                                $curTot,
                                $age30Tot,
                                $age60Tot,
                                $age90Tot,
                                $age120Tot,
                                $grand_total
                            );
                    }
                    if ($client->bad_dr == 'W' && $request->written_off == 'on') {
                        if ($request->branch_id == null)
                            $this->editArray(
                                $debtorAge,
                                $client,
                                $debAge,
                                $credBal,
                                $curTot,
                                $age30Tot,
                                $age60Tot,
                                $age90Tot,
                                $age120Tot,
                                $grand_total
                            );
                        elseif ($request->branch_id == $client->branch_id)
                            $this->editArray(
                                $debtorAge,
                                $client,
                                $debAge,
                                $credBal,
                                $curTot,
                                $age30Tot,
                                $age60Tot,
                                $age90Tot,
                                $age120Tot,
                                $grand_total
                            );
                    }
                } else {
                    if ($request->branch_id == null)
                        $this->editArray(
                            $debtorAge,
                            $client,
                            $debAge,
                            $credBal,
                            $curTot,
                            $age30Tot,
                            $age60Tot,
                            $age90Tot,
                            $age120Tot,
                            $grand_total
                        );
                    elseif ($request->branch_id == $client->branch_id)
                        $this->editArray(
                            $debtorAge,
                            $client,
                            $debAge,
                            $credBal,
                            $curTot,
                            $age30Tot,
                            $age60Tot,
                            $age90Tot,
                            $age120Tot,
                            $grand_total
                        );
                }
            }
        }
        return view('reports.DebtorsAgeAnalysis', compact(
            'eid',
            'branch_name',
            'heading',
            'badDebtorsNote',
            'debtorAgeNote',
            'date',
            'debtorAge',
            'curTot',
            'age30Tot',
            'age60Tot',
            'age90Tot',
            'age120Tot',
            'grand_total',
            'addTelNo'
        ));
    }
    public function editArray(
        &$debtorAge,
        $client,
        $age,
        $include_credits,
        &$curTot,
        &$age30Tot,
        &$age60Tot,
        &$age90Tot,
        &$age120Tot,
        &$grand_total
    ) {
        if ($client->balance != 0) {
            $print = 'N';
            $debtorsAge = new DebtorsAge();
            $date = Carbon::createFromFormat('Y-m-d', $client->last_pmt);
            $debtorsAge->customer = $client->customer;
            $debtorsAge->surname = $client->surname;
            $debtorsAge->initials = $client->initials;
            if ($client->hometel != null)
                $debtorsAge->telNo = $client->hometel;
            else
                $debtorsAge->telNo = $client->work_tel;
            if ($client->cell1 != null)
                $debtorsAge->mobileNo = $client->cell1;
            else
                $debtorsAge->mobileNo = $client->cell2;
            $debtorsAge->lastPmtDate = $date->format('d/m/Y', $date);
            $debtorsAge->lastPmtAmt = $client->last_pmt_amt;
            $debtorsAge->current = $client->current;
            $debtorsAge->days30 = $client->age30;
            $debtorsAge->days60 = $client->age60;
            $debtorsAge->days90 = $client->age90;
            $debtorsAge->days120 = $client->age120;
            $debtorsAge->total = ($client->current + $client->age30 + $client->age60 + $client->age90 + $client->age120);
            if ($age == 5 && $client->balance < 0)
                $print = 'Y';
            elseif ($age == 4 && $client->age120 > 0)
                $print = 'Y';
            elseif ($age == 3 && ($client->age90 + $client->age120) > 0)
                $print = 'Y';
            elseif ($age == 2 && ($client->age60 + $client->age90 + $client->age120) > 0)
                $print = 'Y';
            elseif ($age == 1 && ($client->age30 + $client->age60 + $client->age90 + $client->age120) > 0)
                $print = 'Y';
            elseif ($age == 0 && ((($client->current + $client->age30 + $client->age60 + $client->age90 + $client->age120) > 0)
                or $client->balance > 0))
                $print = 'Y';
            elseif ($age == 0 && ((($client->current + $client->age30 + $client->age60 + $client->age90 + $client->age120) != 0)
                or $client->balance != 0) && $include_credits == 'on')
                $print = 'Y';
            if ($print == 'Y') {
                $curTot = $curTot + $client->current;
                $age30Tot = $age30Tot + $client->age30;
                $age60Tot = $age60Tot + $client->age60;
                $age90Tot = $age90Tot + $client->age90;
                $age120Tot = $age120Tot + $client->age120;
                $grand_total = $grand_total + ($client->current + $client->age30 + $client->age60 + $client->age90 + $client->age120);
                array_push($debtorAge, $debtorsAge);
            }
        }
    }
    public function lastSeen()
    {
        $branches = Branch::where('id', '!=', null)
            ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();

        return view('reports.LastSeen', compact('branches'));
    }
    public function lastSeenClientReport(Request $request)
    {
        if ($request->branch_id == null && $request->print_detail == 'on')
            return Redirect::route('LastSeen')->withInput()->with(
                'danger',
                'Print detail cannot be checked if "All Branches" is selected, report will be too big to display'
            );

        if ($request->branch_id == null)
            $branches = Branch::where('id', '!=', null)
                ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();
        else
            $branches = Branch::where('id', '=', $request->branch_id)->get();

        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::find($user->eid_id);
        $name = $eid->schemaName;
        $date = Carbon::now();
        $edit_date = Carbon::createFromFormat('Y-m-d', $request->last_seenDate);
        $lastSeen_date = $edit_date->format('d/m/Y', $edit_date);
        $grand_total = 0;
        $lastSeen = array();
        $branchArray = array();
        if ($request->print_detail == 'on') {
            foreach ($branches as $branch) {
                if ($branch->id != $request->branch_id)
                    continue;
                $sql = ("select * from $name.clients where last_seen <= '$request->last_seenDate' and last_seen >=
                    '2000-01-01' and branch_id = '$branch->id' ORDER by customer ASC");
                $clients = DB::select($sql);
                $branchTotals = new BranchTotal();
                $client_cnt = 0;
                foreach ($clients as $client) {
                    if ($client->branch_id != $branch->id)
                        continue;
                    if ($client->active == 'N' && $request->ignore_inactiveClients == 'on')
                        continue;
                    $client_cnt = $client_cnt + 1;
                    $lastSeenClient = new LastSeenClients();
                    $lastSeenClient->branch_id = $client->branch_id;
                    $lastSeenClient->customer = $client->customer;
                    $lastSeenClient->clientName = $client->initials . ' ' . $client->surname;
                    $lastSeenClient->hometel = $client->hometel;
                    $lastSeenClient->mobile = $client->cell2;
                    $lastSeenClient->email = $client->email;
                    $tDate = Carbon::createFromFormat('Y-m-d', $client->takeon_date);
                    $lastSeenClient->takeon_date = $tDate->format('d/m/Y', $tDate);
                    $lDate = Carbon::createFromFormat('Y-m-d', $client->last_seen);
                    $lastSeenClient->last_seen = $lDate->format('d/m/Y', $lDate);
                    array_push($lastSeen, $lastSeenClient);
                }
                if ($client_cnt > 0) {
                    $branchTotals->id = $branch->id;
                    $branchTotals->branch_name = $branch->description;
                    $branchTotals->total = $client_cnt;
                    array_push($branchArray, $branchTotals);
                }
                $grand_total = $grand_total + $client_cnt;
            }
            return view('reports.LastSeenReport', compact('date', 'lastSeen_date', 'branchArray', 'lastSeen', 'grand_total'));
        } else {
            foreach ($branches as $branch) {
                if ($request->branch_id != null && $branch->id != $request->branch_id)
                    continue;
                $count = Client::where('last_seen', '<=', $request->last_seenDate)
                    ->where('last_seen', '>=', '2000-01-01')
                    ->where('branch_id', '=', $branch->id)->count();
                $branchTotals = new BranchTotal();
                $branchTotals->id = $branch->id;
                $branchTotals->branch_name = $branch->description;
                $branchTotals->total = $count;
                array_push($branchArray, $branchTotals);
                $grand_total = $grand_total + $count;
            }
            return view('reports.LastSeenReport2', compact('date', 'lastSeen_date', 'branchArray', 'grand_total'));
        }
    }
    public function averageConsult()
    {
        $type = UserType::where('type', '=', 'V')->first();
        $reps = Vetuser::where('id', '>', 0)
            ->where('usertype_id', '=', $type->id)->orderBy('user_name', 'asc')->get();
        $branches = Branch::where('id', '!=', null)
            ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();

        return view('reports.AverageConsults', compact('reps', 'branches'));
    }
    public function averageConsultsByVet(Request $request)
    {
        ini_set('max_execution_time', '-1');
        if ($request->end_date < $request->start_date)
            return Redirect::route('AverageConsult')->withInput()->with('danger', 'Start Date cannot be greater than End Date');

        if ($request->branch_id == null)
            $branch_name = 'All Branches';
        else {
            $branch = Branch::where('id', '=', $request->branch_id)->first();
            $branch_name = $branch->description;
        }
        $repDate = Carbon::now();
        $start_date = date('d/m/Y', strtotime($request->start_date));
        $end_date = date('d/m/Y', strtotime($request->end_date));

        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::find($user->eid_id);
        $schemaName = $eid->schemaName;

        $pieces = array_filter(explode("&", $_SERVER['QUERY_STRING']));
        $params = array();
        foreach ($pieces as $param) {
            list($name, $value) = explode('=', $param, 2);
            $params[urldecode($name)][] = urldecode($value);
        }
        $type = UserType::where('type', '=', 'V')->first();
        $vetsQuery = Vetuser::where('id', '>', 0)
            ->where('usertype_id', '=', $type->id);
        if ($request->user_code != null) {
            if (count($params) > 0) {
                if (array_key_exists("user_code", $params)) {
                    if (array_key_exists("user_code", $params))
                        $vetsQuery = $vetsQuery->wherein('user_code', $params["user_code"]);
                }
            }
        }
        $vets = $vetsQuery->get();
        DB::table($schemaName . '.' . 'vetcons')->truncate();

        foreach ($vets as $vet) {
            $sql = ("select q.invnum, q.q_date, q.systime, q.branch_id, q.customer, i.salesman, i.description, i.amount,
                i.tax, i.discount, i.disc_type from $schemaName.queues q, $schemaName.invoice i where q.q_date >=
                '$request->start_date' AND q.q_date <= '$request->end_date' and q.invnum = i.invnum and i.salesman =
                '$vet->user_code'");
            $invoices = DB::select($sql);

            foreach ($invoices as $invoice) {
                if ($request->user_code != null && $invoice->salesman != $vet->user_code)
                    continue;
                if ($request->branch_id != null && $invoice->branch_id != $request->branch_id)
                    continue;
                if ($invoice->amount + $invoice->discount + $invoice->tax == 0)
                    continue;

                $vetcon = new Vetcons();
                $vetcon->vet = $invoice->salesman;
                $vetcon->vc_date = $invoice->q_date;
                $vetcon->invoice = $invoice->invnum;
                $vetcon->index = 1;
                $vetcon->line = $invoice->description;
                $vetcon->vc_time = $invoice->systime;
                $vetcon->amount = $invoice->amount;
                $vetcon->vat = $invoice->tax;
                $vetcon->discount = $invoice->discount;
                $vetcon->disc_type = $invoice->disc_type;
                $vetcon->branch_id = $invoice->branch_id;
                $vetcon->customer = $invoice->customer;
                $vetcon->save();
            }
        }
        $vetconArray = array();
        $vetconTots = array();
        if ($request->detail_report == null) {
            $vetcons = Vetcons::select(
                'vet',
                'branch_id',
                DB::raw("SUM(amount) as amount"),
                DB::raw("SUM(discount) as discount"),
                DB::raw("SUM(vat) as vat")
            )->where(
                'vc_date',
                '>=',
                $request->start_date
            )->where('vc_date', '<=', $request->end_date)->orderBy('vet', 'asc')
                ->groupBy('vet', 'branch_id')->get();
            foreach ($vetcons as $vetcon) {
                $vetconReport = new VetconReport();
                $vet = Vetuser::where('user_code', '=', $vetcon->vet)->first();
                $invoices = Vetcons::where('vet', '=', $vetcon->vet)
                    ->where('vc_date', '>=', $request->start_date)
                    ->where('vc_date', '<=', $request->end_date)->orderBy('invoice')->get();
                $invnum = null;
                $count = 0;
                foreach ($invoices as $invoice) {
                    if ($invoice->invoice != $invnum)
                        $count = $count + 1;
                    $invnum = $invoice->invoice;
                }
                $b = Branch::where('id', '=', $vetcon->branch_id)->first();
                $vetconReport->branch = $b->description;
                $vetconReport->vet = $vet->user_name;
                $vetconReport->invoice = 'Sales';
                $vetconReport->amount = $vetcon->amount;
                $vetconReport->discount = $vetcon->discount;
                $vetconReport->vat = $vetcon->vat;
                $vetconReport->count = $count;
                $vetconReport->averageAmt = $vetcon->amount / $count;
                $vetconReport->averageDisc = $vetcon->discount / $count;
                $vetconReport->averageVAT = $vetcon->vat / $count;
                $vetconReport->total = $vetcon->amount + $vetcon->discount + $vetcon->vat;
                $vetconReport->averageTotal = $vetconReport->total / $count;
                array_push($vetconArray, $vetconReport);
            }
            return view('reports.AverageVetSummary', compact(
                'branch_name',
                'repDate',
                'start_date',
                'end_date',
                'vetconArray'
            ));
        } else {
            $vetcons = Vetcons::select('vet', 'invoice', DB::raw("SUM(amount) as amount"), DB::raw("SUM(discount) as
                discount"), DB::raw("SUM(vat) as vat"))->where('vc_date', '>=', $request->start_date)->where(
                'vc_date',
                '<=',
                $request->end_date
            )->orderBy('vet', 'asc')->orderBy('invoice', 'asc')->groupBy(
                'vet',
                'invoice'
            )->get();
            $count = 1;
            $amtTot = 0;
            $discTot = 0;
            $vatTot = 0;
            $grandTotal = 0;
            $rep = null;
            foreach ($vetcons as $vetcon) {
                if ($vetcon->vet == $rep) {
                    $count = $count + 1;
                    $amtTot = $amtTot + $vetcon->amount;
                    $discTot = $discTot + $vetcon->discount;
                    $vatTot = $vatTot + $vetcon->vat;
                    $grandTotal = $grandTotal + $vetcon->amount + $vetcon->discount + $vetcon->vat;
                } elseif ($count > 1) {
                    $vetconTotals = new VetconTotals();
                    $vet = Vetuser::where('user_code', '=', $rep)->first();
                    $vetconTotals->user_name = $vet->user_name;
                    $vetconTotals->count = $count;
                    $vetconTotals->averageAmt = $amtTot / $count;
                    $vetconTotals->averageDisc = $discTot / $count;
                    $vetconTotals->averageVAT = $vatTot / $count;
                    $vetconTotals->total = $grandTotal;
                    $vetconTotals->averageTotal = $grandTotal / $count;
                    $count = 1;
                    array_push($vetconTots, $vetconTotals);
                }
                if ($vetcon->vet != $rep) {
                    $amtTot = $vetcon->amount;
                    $discTot = $vetcon->discount;
                    $vatTot = $vetcon->vat;
                    $grandTotal = $vetcon->amount + $vetcon->discount + $vetcon->vat;
                }
                $vetconReport = new VetconReport();
                $vet = Vetuser::where('user_code', '=', $vetcon->vet)->first();
                $vetconReport->vet = $vet->user_name;
                $vetconReport->invoice = $vetcon->invoice;
                $vetconReport->amount = $vetcon->amount;
                $vetconReport->discount = $vetcon->discount;
                $vetconReport->vat = $vetcon->vat;
                $vetconReport->total = $vetcon->amount + $vetcon->discount + $vetcon->vat;
                array_push($vetconArray, $vetconReport);
                $rep = $vetcon->vet;
            }
            $vetconTotals = new VetconTotals();
            $vet = Vetuser::where('user_code', '=', $rep)->first();
            $vetconTotals->user_name = $vet->user_name;
            $vetconTotals->count = $count;
            $vetconTotals->averageAmt = $amtTot / $count;
            $vetconTotals->averageDisc = $discTot / $count;
            $vetconTotals->averageVAT = $vatTot / $count;
            $vetconTotals->total = $grandTotal;
            $vetconTotals->averageTotal = $grandTotal / $count;
            array_push($vetconTots, $vetconTotals);
            return view('reports.AverageConsultsReport', compact(
                'branch_name',
                'repDate',
                'start_date',
                'end_date',
                'vetconArray',
                'vetconTots'
            ));
        }
    }
    public function averageConsultsBreakdown(Request $request)
    {
        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::find($user->eid_id);
        $schemaName = $eid->schemaName;

        $branch_name = $request->branch;
        $repDate = Carbon::now();
        $vetconArray = array();
        $vetconTots = array();
        $vet = Vetuser::where('user_name', 'like', '%' . $request->vet . '%')->first();
        $start_date = date('Y-m-d', strtotime($request->start_date));
        $d = Carbon::createFromFormat('d/m/Y', $request->end_date);
        $end_date = $d->format('Y-m-d', $d);

        $vetcons = DB::select("select invoice, sum(amount) as amount, sum(discount) as discount, sum(vat) as vat from
            $schemaName.vetcons where vet = '$vet->user_code' and vc_date >= '$start_date' and vc_date <= '$end_date'
            group by invoice order by invoice asc");
        $count = 0;
        $amtTot = 0;
        $discTot = 0;
        $vatTot = 0;
        $grandTotal = 0;
        $rep = null;
        foreach ($vetcons as $vetcon) {
            $amtTot = $amtTot + $vetcon->amount;
            $discTot = $discTot + $vetcon->discount;
            $vatTot = $vatTot + $vetcon->vat;
            $grandTotal = $grandTotal + $vetcon->amount + $vetcon->discount + $vetcon->vat;

            $vetconReport = new VetconReport();
            $vetconReport->vet = $request->vet;
            $vetconReport->invoice = $vetcon->invoice;
            $vetconReport->amount = $vetcon->amount;
            $vetconReport->discount = $vetcon->discount;
            $vetconReport->vat = $vetcon->vat;
            $vetconReport->total = $vetcon->amount + $vetcon->discount + $vetcon->vat;
            array_push($vetconArray, $vetconReport);
            $count = $count + 1;
        }
        $vetconTotals = new VetconTotals();
        $vetconTotals->user_name = $request->vet;
        $vetconTotals->count = $count;
        $vetconTotals->averageAmt = $amtTot / $count;
        $vetconTotals->averageDisc = $discTot / $count;
        $vetconTotals->averageVAT = $vatTot / $count;
        $vetconTotals->total = $grandTotal;
        $vetconTotals->averageTotal = $grandTotal / $count;
        array_push($vetconTots, $vetconTotals);

        return view('reports.AverageConsultsReport', compact(
            'branch_name',
            'repDate',
            'start_date',
            'end_date',
            'vetconArray',
            'vetconTots'
        ));
    }
    public function individualStock()
    {
        $warehouses = Warehouse::where('id', '>', 0)->orderBy('name', 'asc')->get();
        $types = Type::where('id', '>', 0)->orderBy('description', 'asc')->get();

        return view('reports.IndividualStock', compact('warehouses', 'types'));
    }
    public function stockItemUsage(Request $request)
    {
        if ($request->end_date <= $request->start_date)
            return Redirect::route('IndividualStock')->withInput()->with('danger', 'Start Date cannot be greater than End Date');

        $code = Code::find($request->code_id);
        $type = Type::find($request->type_id);
        $warehouse = Warehouse::where('id', '=', $request->warehouse_id)->first();

        if ($request->warehouse_id == null) {
            $curbatch = Curbatch::where('dbat_date', '>=', $request->start_date)
                ->where('dbat_date', '<=', $request->end_date)
                ->where('ttype', '=', $type->type)->get();
            $dompojb = Dompojb::where('dpojb_date', '>=', $request->start_date)
                ->where('dpojb_date', '<=', $request->end_date)
                ->where('ttype', '=', $type->type)->get();
        } else {
            $curbatch = Curbatch::where('dbat_date', '>=', $request->start_date)
                ->where('dbat_date', '<=', $request->end_date)
                ->where('ttype', '=', $type->type)
                ->where('branch_id', '=', $request->warehouse_id)->get();
            $dompojb = Dompojb::where('dpojb_date', '>=', $request->start_date)
                ->where('dpojb_date', '<=', $request->end_date)
                ->where('ttype', '=', $type->type)
                ->where('branch_id', '=', $request->warehouse_id)->get();
        }
        $stockItem = array();
        $tot_qty = 0;
        $tot_amount = 0;
        $tot_discount = 0;
        $vat = 0;
        if ($curbatch) {
            foreach ($curbatch as $curbat) {
                if ($curbat->code != $code->code)
                    continue;
                if ($request->warehouse_id != null && $curbat->branch_id != $request->warehouse_id)
                    continue;

                $stockItemUsage = new StockItemUsage();
                $stockItemUsage->warehouse = $curbat->branch_id;
                $stockItemUsage->usage_date = $curbat->dbat_date;
                $stockItemUsage->usage_time = $curbat->dbat_time;
                $stockItemUsage->user = $curbat->rep;
                $stockItemUsage->client = $curbat->customer;
                $stockItemUsage->invoice = $curbat->invoice;
                $stockItemUsage->qty = $curbat->qty;
                $stockItemUsage->amount = $curbat->amount;
                $stockItemUsage->discount = $curbat->dis_amount;
                array_push($stockItem, $stockItemUsage);
                $tot_qty = $tot_qty + $curbat->qty;
                $tot_amount = $tot_amount + $curbat->amount;
                $tot_discount = $tot_discount + $curbat->discount;
                $vat = $vat + $curbat->tax_amount;
            }
        }
        if ($dompojb) {
            foreach ($dompojb as $dompoj) {
                if ($dompoj->code != $code->code)
                    continue;
                if ($request->warehouse_id != null && $dompoj->branch_id != $request->warehouse_id)
                    continue;

                $stockItemUsage = new StockItemUsage();
                $stockItemUsage->warehouse = $dompoj->branch_id;
                $sDate = Carbon::createFromFormat('Y-m-d', $dompoj->dpojb_date);
                $stockItemUsage->usage_date = $sDate->format('d/m/Y', $sDate);
                $stockItemUsage->usage_time = $dompoj->dpojb_time;
                $stockItemUsage->user = $dompoj->rep;
                $stockItemUsage->client = $dompoj->customer;
                $stockItemUsage->invoice = $dompoj->invoice;
                $stockItemUsage->qty = $dompoj->qty;
                $stockItemUsage->amount = $dompoj->amount;
                $stockItemUsage->discount = $dompoj->dis_amount;
                array_push($stockItem, $stockItemUsage);
                $tot_qty = $tot_qty + $dompoj->qty;
                $tot_amount = $tot_amount + $dompoj->amount;
                $tot_discount = $tot_discount + $dompoj->discount;
                $vat = $vat + $dompoj->tax_amount;
            }
        }
        $sDate = Carbon::createFromFormat('Y-m-d', $request->start_date);
        $start_date = $sDate->format('d/m/Y', $sDate);
        $start_time = $request->start_time;
        $eDate = Carbon::createFromFormat('Y-m-d', $request->end_date);
        $end_date = $eDate->format('d/m/Y', $eDate);
        $end_time = $request->end_time;

        return view('reports.StockItemUsage', compact(
            'code',
            'type',
            'warehouse',
            'start_date',
            'start_time',
            'end_date',
            'end_time',
            'stockItem',
            'tot_qty',
            'tot_amount',
            'tot_discount',
            'vat'
        ));
    }
    public function reprintTill()
    {
        $reps = Vetuser::where('id', '>', 0)->orderBy('user_code', 'asc')->get();
        $tills = Till::select('number')->where('id', '>', 0)->groupBy('number')->orderBy('number', 'asc')->get();
        return view('reports.ReprintTill', compact('reps', 'tills'));
    }
    public function tillLedger(Request $request)
    {
        if ($request->till_no == null && $request->start_date == null && $request->end_date == null)
            return Redirect::route('ReprintTill')->withInput()->with('danger', 'Either ledger number or dates must be entered');

        if ($request->end_date < $request->start_date)
            return Redirect::route('ReprintTill')->withInput()->with('danger', 'Start Date cannot be greater than End Date');

        if ($request->start_date == null && $request->end_date != null)
            return Redirect::route('ReprintTill')->withInput()->with('danger', 'Both dates must either be null or edited');

        if ($request->till_no != null && $request->start_date != null && $request->end_date != null)
            return Redirect::route('ReprintTill')->withInput()->with('danger', 'If till ledger is entered both dates must be null');

        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::find($user->eid_id);
        $name = $eid->schemaName;

        $operator = Vetuser::where('user_code', '=', $request->user_code)->first();
        $start_date = date('d/m/Y', strtotime($request->start_date));
        $end_date = date('d/m/Y', strtotime($request->end_date));
        $date = Carbon::now();

        if ($request->till_no == null) {
            $till_no = 'All Till Ledgers';
            $sql = ("select t.type, pt.description, sum(amount) as amount from $name.tills t, $name.paymenttypes pt where
            till_date >= '$request->start_date' and till_date <= '$request->end_date' and vetuser_id = $operator->id and
            t.type = pt.type GROUP by t.type, pt.description");
            $payment_types = DB::select($sql);
            if ($request->start_date == null)
                $tills = Till::where('vetuser_id', '=', $operator->id)->get();
            else
                $tills = Till::where('till_date', '>=', $request->start_date)
                    ->where('till_date', '<=', $request->end_date)
                    ->where('vetuser_id', '=', $operator->id)->get();
        } else {
            $till_no = $request->till_no;
            $sql = ("select t.type, pt.description, sum(amount) as amount from $name.tills t, $name.paymenttypes pt where
            vetuser_id = $operator->id and t.type = pt.type and number = $till_no GROUP by t.type, pt.description");
            $payment_types = DB::select($sql);
            if ($request->start_date == null)
                $tills = Till::where('vetuser_id', '=', $operator->id)
                    ->where('number', '=', $till_no)->get();
            else
                $tills = Till::where('till_date', '>=', $request->start_date)
                    ->where('till_date', '<=', $request->end_date)
                    ->where('vetuser_id', '=', $operator->id)
                    ->where('number', '=', $till_no)->get();
        }
        $tillsCashup = array();
        $grand_totals = 0;
        foreach ($tills as $till) {
            $tillCashup = new TillCashup();
            $pay_type = PaymentType::where('type', '=', $till->type)->first();
            $tillCashup->description = $pay_type->description;
            $tillCashup->tillNo = $till->number;
            $tillCashup->till_date = date('d/m/Y', strtotime($till->till_date));
            $tillCashup->customer = $till->customer;
            $client = Client::where('customer', '=', $till->customer)->first();
            $tillCashup->initials = $client->initials;
            $tillCashup->surname = $client->surname;
            $tillCashup->amount = $till->amount;
            array_push($tillsCashup, $tillCashup);
            $grand_totals = $grand_totals + $till->amount;
        }
        if ($request->till_no == null) {
            return view('reports.ReprintTillReport2', compact(
                'operator',
                'start_date',
                'end_date',
                'date',
                'till_no',
                'payment_types',
                'tillsCashup',
                'grand_totals'
            ));
        } else
            return view('reports.ReprintTillReport', compact(
                'operator',
                'start_date',
                'end_date',
                'date',
                'till_no',
                'payment_types',
                'tillsCashup',
                'grand_totals'
            ));
    }
    public function bankingSummary()
    {
        $branches = Branch::where('id', '!=', null)
            ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();
        $payments = PaymentType::where('id', '>', 0)->orderBy('description', 'asc')->get();

        return view('reports.BankingSummary', compact('branches', 'payments'));
    }
    public function bankingSummaryReport(Request $request)
    {
        ini_set('max_execution_time', '-1');
        if ($request->end_date < $request->start_date)
            return Redirect::route('BankingSummary')->withInput()->with('danger', 'Start Date cannot be greater than End Date');

        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::find($user->eid_id);
        $name = $eid->schemaName;

        $date = Carbon::now();
        $start_date = date('d/m/Y', strtotime($request->start_date));
        $end_date = date('d/m/Y', strtotime($request->end_date));

        DB::table($name . '.' . 'banksums')->truncate();
        $type = Type::where('type', '=', 'C')->first();

        if ($request->branch_id == null) {
            $dompojb = DB::select("select ref, batch, count, dpojb_date, amount, cost, tax_amount, dis_amount, branch_id,
                customer, rep, ttype from $name.dompojb where dpojb_date >= '$request->start_date' and dpojb_date <=
                '$request->end_date' and type_id = $type->id order by customer asc");
            $branch = 'All Branches';
        } else {
            $dompojb = DB::select("select ref, batch, count, dpojb_date, amount, cost, tax_amount, dis_amount, branch_id,
                customer,  rep, ttype from $name.dompojb where dpojb_date >= '$request->start_date' and dpojb_date <=
                '$request->end_date' and type_id = $type->id and branch_id = '$request->branch_id' order by customer asc");
            $b = Branch::find($request->branch_id);
            $branch = $b->description;
        }
        foreach ($dompojb as $dompoj) {
            $pay_type = substr($dompoj->ref, 15, 1);
            $payType = PaymentType::where('type', '=', $pay_type)->first();

            $banksum = new Banksum();
            $banksum->reference = $dompoj->ref;
            $banksum->batch = $dompoj->batch;
            $banksum->counter = $dompoj->count;
            $banksum->bs_date = $dompoj->dpojb_date;
            $banksum->amount = ($dompoj->amount + $dompoj->tax_amount) * -1;
            if ($dompoj->ttype == 'F')
                $banksum->amount = $dompoj->cost * -1;
            $banksum->discount = $dompoj->dis_amount * -1;
            $banksum->branch_id = $dompoj->branch_id;
            $banksum->paytype_id = $payType->id;
            $banksum->customer = $dompoj->customer;
            $banksum->save();
        }
        if ($request->detail_report == null) {
            $banksums = Banksum::select('paytype_id', DB::raw("SUM(amount) as amount"), DB::raw("SUM(discount) as
                discount"))->where('bs_date', '>=', $request->start_date)->where('bs_date', '<=', $request->end_date)
                ->groupBy('paytype_id')->get();

            $bankArray = array();
            $tot_amount = 0;
            $tot_dis = 0;
            foreach ($banksums as $banksum) {
                if ($request->payment_type != null && $banksum->paytype_id != $request->payment_type)
                    continue;
                $bankSummary = new BanksumSummary();
                $payType = PaymentType::where('id', '=', $banksum->paytype_id)->first();
                $bankSummary->paymentType = $payType->description;
                $bankSummary->amount = $banksum->amount;
                $bankSummary->discount = $banksum->discount;
                $tot_amount = $tot_amount + $banksum->amount;
                $tot_dis = $tot_dis + $banksum->discount;
                array_push($bankArray, $bankSummary);
            }
            return view('reports.BankingSummaryReport', compact(
                'date',
                'start_date',
                'end_date',
                'branch',
                'bankArray',
                'tot_amount',
                'tot_dis'
            ));
        } else {
            $banksums = Banksum::select(
                'paytype_id',
                'customer',
                'reference',
                'bs_date',
                DB::raw("SUM(amount) as amount"),
                DB::raw("SUM(discount) as discount")
            )->where('bs_date', '>=', $request->start_date)->where(
                'bs_date',
                '<=',
                $request->end_date
            )->orderBy('paytype_id', 'asc')->orderBy('customer', 'asc')->groupBy(
                'paytype_id',
                'customer',
                'reference',
                'bs_date'
            )->get();
            $pay_type = 0;
            $amount_totals = 0;
            $discount_totals = 0;
            $grand_amount = 0;
            $grand_discount = 0;
            $bankArray = array();
            $banksumDet = array();
            foreach ($banksums as $banksum) {
                if ($request->payment_type != null && $banksum->paytype_id != $request->payment_type)
                    continue;

                $banksumDetails = new BanksumDetails();
                $payment_type = PaymentType::where('id', '=', $banksum->paytype_id)->first();

                if ($banksum->paytype_id == $pay_type) {
                    $amount_totals = $amount_totals + $banksum->amount;
                    $discount_totals = $discount_totals + $banksum->discount;
                } elseif ($pay_type > 0) {
                    $bankSummary = new BanksumSummary();
                    $payType = PaymentType::where('id', '=', $pay_type)->first();
                    $bankSummary->paymentType = $payType->description;
                    $bankSummary->amount = $bankSummary->amount + $amount_totals;
                    $bankSummary->discount = $bankSummary->discount + $discount_totals;
                    array_push($bankArray, $bankSummary);
                }
                if ($banksum->paytype_id != $pay_type) {
                    $amount_totals = $banksum->amount;
                    $discount_totals = $banksum->discount;
                }
                $pay_type = $banksum->paytype_id;
                $banksumDetails->paymentType = $payment_type->description;
                $banksumDetails->customer = $banksum->customer;
                $client = Client::where('customer', '=', $banksum->customer)->first();
                $banksumDetails->surname = $client->surname;
                $banksumDetails->reference = $banksum->reference;
                $banksumDetails->bank_date = date('d/m/Y', strtotime($banksum->bs_date));
                $banksumDetails->amount = $banksum->amount;
                $banksumDetails->discount = $banksum->discount;
                array_push($banksumDet, $banksumDetails);
                $grand_amount = $grand_amount + $banksum->amount;
                $grand_discount = $grand_discount + $banksum->discount;
            }
            if ($pay_type != null) {
                $bankSummary = new BanksumSummary();
                $payType = PaymentType::where('id', '=', $pay_type)->first();
                $bankSummary->paymentType = $payType->description;
                $bankSummary->amount = $bankSummary->amount + $amount_totals;
                $bankSummary->discount = $bankSummary->discount + $discount_totals;
                array_push($bankArray, $bankSummary);
            }
            return view('reports.BankingSummaryReport2', compact(
                'date',
                'start_date',
                'end_date',
                'branch',
                'bankArray',
                'banksumDet',
                'amount_totals',
                'discount_totals',
                'grand_amount',
                'grand_discount'
            ));
        }
    }
    public function clientInformation()
    {
        $branches = Branch::where('id', '!=', null)
            ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();

        return view('reports.ClientInfo', compact('branches'));
    }
    public function clientInformationReport(Request $request)
    {
        if ($request->startLetter == null)
            return Redirect::route('ClientInfo')->withInput()->with('danger', 'Start Letter must be entered');

        $startLength = Str::length($request->startLetter);
        if ($startLength > 1)
            return Redirect::route('ClientInfo')->withInput()
                ->with('danger', 'Start Letter cannot be more than two characters');

        if ($request->client_status == 'on') {
            $active = 'Y';
            $status = 'Yes';
        } else {
            $active = 'N';
            $status = 'No';
        }
        $clients = Client::where('active', '=', $active)
            ->where('branch_id', '=', $request->branch_id)->orderBy('surname', 'asc')->get();
        $b = Branch::find($request->branch_id);
        $branch = $b->description;

        $clientArray = array();
        foreach ($clients as $client) {
            if (substr($client->surname, 0, 1) == $request->startLetter) {
                $clientInfo = new ClientInformation();
                $clientInfo->customer = $client->customer;
                $clientInfo->surname = $client->surname;
                $clientInfo->firstnames = $client->firstnames;
                $clientInfo->title = $client->title;
                $clientInfo->id_number = $client->id_number;
                $clientInfo->address1 = $client->address1;
                $clientInfo->address2 = $client->address2;
                $clientInfo->address3 = $client->address3;
                $clientInfo->code = $client->code;
                $clientInfo->hometel = $client->hometel;
                $clientInfo->cell2 = $client->cell2;
                $clientInfo->email = $client->email;
                array_push($clientArray, $clientInfo);
            }
        }
        return view('reports.ClientInformation', compact('branch', 'clientArray', 'status'));
    }
    public function userTravel()
    {
        return view('reports.UserTravel');
    }
    public function travelPerType()
    {
        $userTypes = UserType::where('id', '>', 0)->orderBy('description', 'asc')->get();
        return view('reports.UserTravelPerType', compact('userTypes'));
    }
    public function travelPerCode()
    {
        $reps = Vetuser::all();
        return view('reports.UserTravelPerCode', compact('reps'));
    }
    public function userTravelReport(Request $request)
    {
        if ($request->end_date < $request->start_date)
            return Redirect::route('TravelPerCode')->withInput()->with('danger', 'Start Date cannot be greater than End Date');

        if ($request->start_date != null && $request->end_date == null)
            return Redirect::route('TravelPerCode')->withInput()->with('danger', 'Both dates must either be null or edited');

        if ($request->start_date == null && $request->end_date != null)
            return Redirect::route('TravelPerCode')->withInput()->with('danger', 'Both dates must either be null or edited');

        if ($request->user_code == null)
            return Redirect::route('TravelPerCode')->withInput()->with('danger', 'User Code cannot be null');

        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::find($user->eid_id);
        $name = $eid->schemaName;
        $start_date = null;
        $end_date = null;

        $vet = Vetuser::where('id', '=', $request->user_code)->first();
        if ($request->start_date != null) {
            $start_date = date('d/m/Y', strtotime($request->start_date));
            $end_date = date('d/m/Y', strtotime($request->end_date));
            $sql = ("select TO_CHAR(invoice_date, 'DD/MM/YYYY') as invoice_date, customer, description,
                qty_shipped, amount, discount, tax, cost from $name.invoice where invoice_date >= '$request->start_date'
                and invoice_date <= '$request->end_date' and itemcat = 'T' and salesman = '$vet->user_code'");
        } else
            $sql = ("select TO_CHAR(invoice_date, 'DD/MM/YYYY') as invoice_date, customer, description, qty_shipped,
                amount, discount, tax, cost from $name.invoice where itemcat = 'T' and salesman = '$vet->user_code'");
        $invoices = DB::select($sql);

        return view('reports.UserTravelReport', compact('start_date', 'end_date', 'vet', 'invoices'));
    }
    public function userTravelReport2(Request $request)
    {
        if ($request->end_date < $request->start_date)
            return Redirect::route('TravelPerType')->withInput()->with('danger', 'Start Date cannot be greater than End Date');

        if ($request->start_date != null && $request->end_date == null)
            return Redirect::route('TravelPerType')->withInput()->with('danger', 'Both dates must either be null or edited');

        if ($request->start_date == null && $request->end_date != null)
            return Redirect::route('TravelPerType')->withInput()->with('danger', 'Both dates must either be null or edited');

        if ($request->user_type == null)
            return Redirect::route('TravelPerType')->withInput()->with('danger', 'User Type cannot be null');

        $start_date = null;
        $end_date = null;
        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::find($user->eid_id);
        $name = $eid->schemaName;

        $type = UserType::find($request->user_type);
        if ($request->start_date != null) {
            $start_date = date('d/m/Y', strtotime($request->start_date));
            $end_date = date('d/m/Y', strtotime($request->end_date));
            $sql = ("select user_name, TO_CHAR(invoice_date, 'DD/MM/YYYY') as invoice_date, customer, description,
                qty_shipped, amount, discount, tax, cost from $name.invoice, $name.vetusers where invoice_date >=
                '$request->start_date' and invoice_date <= '$request->end_date' and itemcat = 'T' and usertype_id =
                $request->user_type");
        } else
            $sql = ("select user_name, TO_CHAR(invoice_date, 'DD/MM/YYYY') as invoice_date, customer, description,
                qty_shipped, amount, discount, tax, cost from $name.invoice, $name.vetusers where itemcat = 'T' and
                usertype_id = $request->user_type");
        $invoices = DB::select($sql);

        return view('reports.UserTravelReport2', compact('start_date', 'end_date', 'type', 'invoices'));
    }
    public function stockValuation()
    {
        $warehouses = Warehouse::where('id', '>', 0)->orderBy('name', 'asc')->get();
        $types = Type::where('id', '>', 0)->orderBy('description', 'asc')->get();
        $suppliers = Supplier::where('id', '>', 0)->orderBy('name', 'asc')->get();

        return view('reports.StockValuation', compact('warehouses', 'types', 'suppliers'));
    }
    public function StockValuationReport(Request $request)
    {
        ini_set('max_execution_time', '-1');
        if ($request->stock_type == 'on' && $request->type_id != null)
            return Redirect::route('StockValuation')->withInput()
                ->with('danger', 'If Report on All Stock Types is checked, Stock Type must be null');

        if ($request->stock_type == null && $request->type_id == null)
            return Redirect::route('StockValuation')->withInput()
                ->with('danger', 'If Report on All Stock Types is not checked, Stock Type cannot be null');

        if ($request->change_amt == 'on' && $request->negative_stock == null)
            return Redirect::route('StockValuation')->withInput()
                ->with('danger', 'If Change Negative Stock Amount is checked, Include Negative Stock must also be checked');
        if ($request->warehouse_id == null) {
            $warehouse = 'All Warehouses';
        } else {
            $warehs = Warehouse::find($request->warehouse_id);
            $warehouse = $warehs->name;
        }
        if ($request->type_id == null)
            $types = Type::where('id', '>', 0)->orderBy('type', 'asc')->get();
        else
            $types = Type::where('id', '=', $request->type_id)->get();
        $date = Carbon::now();
        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::find($user->eid_id);
        $name = $eid->schemaName;

        $checkType = null;
        $stockArray = array();
        $typeArray = array();
        $warehsTots = array();
        $grand_cost = 0;
        $grand_sales = 0;
        if ($request->detail_report == null) {
            foreach ($types as $type) {
                if (
                    $type->type == 'A' or $type->type == 'C' or $type->type == 'K' or $type->type == 'I' or $type->type
                    == 'P' or $type->type == 'S' or $type->type == 'T'
                )
                    continue;

                $stocks = Stock::select(
                    'type_id',
                    'warehouse_id',
                    DB::raw("SUM(cost_price*quantity_on_hand) as cost_price"),
                    DB::raw("SUM(sales_price*quantity_on_hand) as sales_price")
                )->where('type_id', '=', $type->id)
                    ->groupBy('warehouse_id')->groupBy('type_id')->orderBy('warehouse_id', 'asc')->get();

                $warehs_cost = 0;
                $warehs_sales = 0;
                foreach ($stocks as $stock) {
                    $warehsTotals = new WarehouseTotal();
                    $warehs = Warehouse::find($stock->warehouse_id);
                    $warehsTotals->name = $warehs->name;
                    $warehsTotals->type_id = $type->id;
                    $warehsTotals->cost_price = $stock->cost_price;
                    $warehsTotals->sales_price = $stock->sales_price;
                    array_push($warehsTots, $warehsTotals);

                    $warehs_cost = $warehs_cost + $stock->cost_price;
                    $warehs_sales = $warehs_sales + $stock->sales_price;


                $typesArray = new TypesArray();
                $typesArray->type_id = $stock->type_id;
                $typesArray->description = $type->description;
                $typesArray->cost_price = $warehs_cost;
                $typesArray->sales_price = $warehs_sales;
                array_push($typeArray, $typesArray);
                $grand_cost = $grand_cost + $warehs_cost;
                $grand_sales = $grand_sales + $warehs_sales;
            }
            }
            $warehouseTots = array();
            $sql = ("select warehouse_id, sum(cost_price*quantity_on_hand) as cost_price,
                    sum(sales_price*quantity_on_hand) as sales_price from $name.stocks, $name.types t where
                    type_id = t.id and type != 'A' and type != 'C' and type != 'K' and type != 'I' and type != 'P' and
                    type != 'S' and type != 'T' group by warehouse_id ORDER BY warehouse_id ASC");
            $stocks = DB::select($sql);
            foreach ($stocks as $stock) {
                $warehouseTot = new GrandTotal();
                $wh = Warehouse::find($stock->warehouse_id);
                $warehouseTot->name = $wh->name;
                $warehouseTot->cost_price = $stock->cost_price;
                $warehouseTot->sales_price = $stock->sales_price;
                array_push($warehouseTots, $warehouseTot);
            }
            return view('reports.StockValuationReport2', compact(
                'date',
                'warehouse',
                'typeArray',
                'warehsTots',
                'grand_cost',
                'grand_sales',
                'warehouseTots'
            ));
        } else {
            foreach ($types as $type) {
                if (
                    $type->type == 'A' or $type->type == 'C' or $type->type == 'K' or $type->type == 'I' or
                    $type->type == 'P' or $type->type == 'S' or $type->type == 'T'
                )
                    continue;

                $sql = ("select warehouse_id, s.type_id, s.code_id, c.description, supplier, manufacturer, uom,
                    quantity_on_hand, sum(cost_price*quantity_on_hand) as cost_price, sum(sales_price*quantity_on_hand)
                    as sales_price from $name.stocks s, $name.codes c where s.type_id = $type->id and s.type_id = c.type_id
                    and s.code_id = c.id group by warehouse_id, s.type_id, s.code_id, c.description, supplier,
                    manufacturer, uom, quantity_on_hand ORDER BY description ASC");
                $stocks = DB::select($sql);

                $warehs_cost = 0;
                $warehs_sales = 0;
                foreach ($stocks as $stock) {
                    if ($stock->quantity_on_hand == 0)
                        continue;
                    if ($request->negative_stock == null && $stock->quantity_on_hand < 0)
                        continue;
                    if ($request->negative_stock == 'on' && $request->change_amt == 'on' && $stock->quantity_on_hand < 0)
                        $stock->quantity_on_hand = $stock->quantity_on_hand * -1;

                    // display record per code
                    $stockValuation = new StockValuation();
                    $stockValuation->typeDesc = $type->description;
                    $stockValuation->warehouse = $stock->warehouse_id;
                    $stockValuation->description = $stock->description;
                    $stockValuation->uom = $stock->uom;
                    $stockValuation->qty_oh = $stock->quantity_on_hand;
                    $stockValuation->cost_price = $stock->cost_price;
                    $stockValuation->sales_price = $stock->sales_price;
                    array_push($stockArray, $stockValuation);

                    $warehs_cost = $warehs_cost + $stock->cost_price;
                    $warehs_sales = $warehs_sales + $stock->sales_price;
                }
                // calculate totals per type
                $typesArray = new TypesArray();
                $typesArray->type_id = $stock->type_id;
                $typesArray->description = $type->description;
                $typesArray->cost_price = $warehs_cost;
                $typesArray->sales_price = $warehs_sales;
                array_push($typeArray, $typesArray);
                $grand_cost = $grand_cost + $warehs_cost;
                $grand_sales = $grand_sales + $warehs_sales;

                // calculate totals per type per warehouse
                $wtots = Stock::select(
                    'type_id',
                    'warehouse_id',
                    DB::raw("SUM(cost_price*quantity_on_hand) as cost_price"),
                    DB::raw("SUM(sales_price*quantity_on_hand) as sales_price")
                )->where('type_id', '=', $type->id)
                    ->groupBy('warehouse_id')->groupBy('type_id')->orderBy('warehouse_id', 'asc')->get();

                foreach ($wtots as $wtot) {
                    $warehsTotals = new WarehouseTotal();
                    $warehs = Warehouse::find($wtot->warehouse_id);
                    $warehsTotals->name = $warehs->name;
                    $warehsTotals->type_id = $type->id;
                    $warehsTotals->cost_price = $wtot->cost_price;
                    $warehsTotals->sales_price = $wtot->sales_price;
                    array_push($warehsTots, $warehsTotals);
                }
            }
            //calculate grand totals per warehouse
            $warehouseTots = array();
            $sql = ("select warehouse_id, sum(cost_price*quantity_on_hand) as cost_price,
                    sum(sales_price*quantity_on_hand) as sales_price from $name.stocks, $name.types t where
                    type_id = t.id and type != 'A' and type != 'C' and type != 'K' and type != 'I' and type != 'P' and
                    type != 'S' and type != 'T' group by warehouse_id ORDER BY warehouse_id ASC");
            $stocks = DB::select($sql);
            foreach ($stocks as $stock) {
                $warehouseTot = new GrandTotal();
                $wh = Warehouse::find($stock->warehouse_id);
                $warehouseTot->name = $wh->name;
                $warehouseTot->cost_price = $stock->cost_price;
                $warehouseTot->sales_price = $stock->sales_price;
                array_push($warehouseTots, $warehouseTot);
            }
            return view('reports.StockValuationReport', compact(
                'warehouse',
                'date',
                'typeArray',
                'stockArray',
                'grand_cost',
                'grand_sales',
                'warehsTots',
                'warehouseTots'
            ));
        }
    }
    public function patientFlag()
    {
        $branches = Branch::where('id', '!=', null)
            ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();

        return view('reports.PatientFlag', compact('branches'));
    }
    public function patientFlagReport(Request $request)
    {
        ini_set('max_execution_time', '-1');
        if ($request->startLetter == null)
            return Redirect::route('PatientFlag')->withInput()->with('danger', 'Start Letter must be entered');

        $startLength = Str::length($request->startLetter);
        if ($startLength > 1)
            return Redirect::route('PatientFlag')->withInput()
                ->with('danger', 'Start Letter cannot be more than two characters');

        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();
        $eid = EID::find($user->eid_id);
        $name = $eid->schemaName;

        if ($request->branch_id == null)
            $branches = Branch::where('id', '!=', null)
                ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();
        else
            $branches = Branch::where('id', '=', $request->branch_id)->get();
        $date = Carbon::now();

        if ($request->patient_flag == 'A') {
            $patientFlag = 'Active Patients';
        } else {
            $patientFlag = 'Inactive Patients';
        }
        $patient_clientArray = array();
        $branchArray = array();
        $grand_total = 0;
        if ($request->print_detail == 'on') {
            foreach ($branches as $branch) {
                if (($request->branch_id != null) && $branch->id != $request->branch_id)
                    continue;
                if ($request->patient_flag == 'A')
                    $sql = ("select * from $name.patients where branch_id = '$branch->id' and active = 'Y' order BY
                        patient ASC");
                else
                    $sql = ("select * from $name.patients where branch_id = '$branch->id' and active != 'Y' order BY
                        patient ASC");
                $patients = DB::select($sql);
                $branchTotals = new BranchTotal();
                $patientCnt = 0;
                foreach ($patients as $patient) {
                    if ($patient->branch_id != $branch->id)
                        continue;
                    if ($patient->type == 'SYS')
                        continue;
                    //if ($patient->type != 'FEL' && $patient->type != 'CAN' && $patient->reminders == 'Y')
                    //    continue;
                    if ($request->patient_flag == 'A' && $patient->dead == 'Y')
                        continue;
                    if ($request->patient_flag == 'I' && $patient->dead == 'N')
                        continue;

                    if (substr($patient->name, 0, 1) == $request->startLetter) {
                        $patientStatus = new PatientStatus();
                        $patientStatus->branch_id = $patient->branch_id;
                        $patientStatus->patient = $patient->patient;
                        $patientStatus->patientName = $patient->name;
                        $editDate = Carbon::createFromFormat('Y-m-d', $patient->dob);
                        $patientStatus->dob = $editDate->format('d/m/Y', $editDate);
                        $patientStatus->breed = $patient->breed;
                        $editDate = Carbon::createFromFormat('Y-m-d', $patient->takeon_date);
                        $patientStatus->takeon_date = $editDate->format('d/m/Y', $editDate);
                        if ($patient->dead == 'Y') {
                            $editDate = Carbon::createFromFormat('Y-m-d', $patient->dod);
                            $patientStatus->dod = $editDate->format('d/m/Y', $editDate);
                        }
                        array_push($patient_clientArray, $patientStatus);
                        $patientCnt = $patientCnt + 1;
                    }
                }
                if ($patientCnt > 0) {
                    $branchTotals->id = $branch->id;
                    $branchTotals->branch_name = $branch->description;
                    $branchTotals->total = $patientCnt;
                    array_push($branchArray, $branchTotals);
                }
                $grand_total = $grand_total + $patientCnt;
            }
            return view('reports.PatientFlagReport', compact(
                'patientFlag',
                'date',
                'patient_clientArray',
                'branchArray',
                'grand_total'
            ));
        } else {
            foreach ($branches as $branch) {
                if ($request->branch_id != null && $branch->id != $request->branch_id)
                    continue;
                if ($request->patient_flag == 'A')
                    $count = Patient::where('active', '=', 'Y')
                        ->where('dead', '!=', 'Y')
                        ->where('type', '!=', 'SYS')
                        ->where('branch_id', '=', $branch->id)->count();
                else
                    $count = Patient::where('active', '!=', 'Y')
                        ->where('dead', '=', 'Y')
                        ->where('type', '!=', 'SYS')
                        ->where('branch_id', '=', $branch->id)->count();
                $branchTotals = new BranchTotal();
                $branchTotals->id = $branch->id;
                $branchTotals->branch_name = $branch->description;
                $branchTotals->total = $count;
                array_push($branchArray, $branchTotals);
                $grand_total = $grand_total + $count;
            }
            return view('reports.PatientFlagReport2', compact('patientFlag', 'date', 'branchArray', 'grand_total'));
        }
    }
    public function clientDiscount()
    {
        $branches = Branch::where('id', '!=', null)
            ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();

        return view('reports.ClientDiscount', compact('branches'));
    }
    public function clientDiscReport(Request $request)
    {
        ini_set('max_execution_time', '-1');
        if ($request->end_date < $request->start_date)
            return Redirect::route('ClientDiscount')->withInput()->with('danger', 'End Date cannot be less than Start Date');

        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();
        $eid = EID::find($user->eid_id);
        $name = $eid->schemaName;

        if ($request->branch_id == null)
            $branches = Branch::where('id', '!=', null)
                ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();
        else
            $branches = Branch::where('id', '=', $request->branch_id)->orderBy('description', 'asc')->get();
        $start_date = date('d/m/Y', strtotime($request->start_date));
        $end_date = date('d/m/Y', strtotime($request->end_date));
        $type = Type::where('type', '=', 'I')->first();
        $cus_amt = 0;
        $cus_dis = 0;
        $cus_cost = 0;
        $cus_vat = 0;
        $branchArray = array();
        $clientDisc = array();
        foreach ($branches as $branch) {
            $branch_amt = 0;
            $branch_cost = 0;
            $branch_discount = 0;
            $customer = null;
            $query = ("select dpojb_date, ttype, customer, invoice, amount, dis_amount, cost, tax_amount, type_id, rep,
                ref, branch_id from $name.dompojb where dpojb_date >= '$request->start_date' and dpojb_date <=
                '$request->end_date' and type_id = $type->id and branch_id = '$branch->id' order by dpojb_date asc,
                customer asc");
            $dompojb = DB::select($query);

            foreach ($dompojb as $dompoj) {
                if ($dompoj->ttype != 'R' && $dompoj->dis_amount == 0)
                    continue;

                if ($request->exclude_discounts == 'on') {
                    if ($dompoj->ttype == 'R')
                        continue;
                }
                if ($request->print_byClient == 'on') {
                    if ($dompoj->customer == $customer) {
                        $cus_amt = $cus_amt + $dompoj->amount;
                        $cus_dis = $cus_dis + $dompoj->dis_amount;
                        $cus_cost = $cus_cost + $dompoj->cost;
                        $cus_vat = $cus_vat + $dompoj->tax_amount;
                    } elseif ($customer != null) {
                        $clientDiscount = new ClientDiscount();
                        $clientDiscount->branch = $dompoj->branch_id;
                        $clientDiscount->customer = 'Total For:';
                        $clientDiscount->invoice = 'Customer';
                        $clientDiscount->inv_date = $customer;
                        $client = Client::where('customer', '=', $customer)->first();
                        $clientDiscount->user = $client->initials;
                        $clientDiscount->type = null;
                        $clientDiscount->reference = $client->surname;
                        $clientDiscount->amount = $cus_amt;
                        $clientDiscount->cost = $cus_cost;
                        $clientDiscount->discount = $cus_dis;
                        if ($cus_amt != 0) {
                            $clientDiscount->disc_perc = ($cus_dis * -1) / $cus_amt * 100;
                            if ($clientDiscount->disc_perc > 100 or $clientDiscount->disc_perc < 0)
                                $clientDiscount->disc_perc = '?????';
                        } else
                            $clientDiscount->disc_perc = 0;
                        array_push($clientDisc, $clientDiscount);

                        $cus_amt = $dompoj->amount;
                        $cus_dis = $dompoj->dis_amount;
                        $cus_cost = $dompoj->cost;
                        $cus_vat = $dompoj->tax_amount;
                    } else {
                        $cus_amt = $dompoj->amount;
                        $cus_dis = $dompoj->dis_amount;
                        $cus_cost = $dompoj->cost;
                        $cus_vat = $dompoj->tax_amount;
                    }
                }
                if ($request->print_transactions == 'on') {
                    $clientDiscount = new ClientDiscount();
                    $clientDiscount->branch = $dompoj->branch_id;
                    $clientDiscount->customer = $dompoj->customer;
                    $clientDiscount->invoice = $dompoj->invoice;
                    $clientDiscount->user = $dompoj->rep;
                    $clientDiscount->inv_date = date('d/m/Y', strtotime($dompoj->dpojb_date));
                    $clientDiscount->type = $dompoj->ttype;
                    $clientDiscount->reference = $dompoj->ref;
                    $clientDiscount->amount = $dompoj->amount;
                    $clientDiscount->cost = $dompoj->cost;
                    $clientDiscount->discount = $dompoj->dis_amount;
                    if ($dompoj->amount != 0) {
                        $clientDiscount->disc_perc = ($dompoj->dis_amount * -1) / $dompoj->amount * 100;
                        if ($clientDiscount->disc_perc > 100 or $clientDiscount->disc_perc < 0)
                            $clientDiscount->disc_perc = 0;
                    } else
                        $clientDiscount->disc_perc = 0;
                    array_push($clientDisc, $clientDiscount);
                }
                $customer = $dompoj->customer;
                $branch_amt = $branch_amt + $dompoj->amount;
                $branch_cost = $branch_cost + $dompoj->cost;
                $branch_discount = $branch_discount + $dompoj->dis_amount;
            }
            if ($customer != null) {
                $clientDiscount = new ClientDiscount();
                $clientDiscount->branch = $branch->id;
                $clientDiscount->customer = 'Total For:';
                $clientDiscount->invoice = 'Customer';
                $clientDiscount->inv_date = $customer;
                $client = Client::where('customer', '=', $customer)->first();
                $clientDiscount->user = $client->initials;
                $clientDiscount->type = null;
                $clientDiscount->reference = $client->surname;
                $clientDiscount->amount = $cus_amt;
                $clientDiscount->cost = $cus_cost;
                $clientDiscount->discount = $cus_dis;
                if ($cus_amt != 0) {
                    $clientDiscount->disc_perc = ($cus_dis * -1) / $cus_amt * 100;
                    if ($clientDiscount->disc_perc > 100 or $clientDiscount->disc_perc < 0)
                        $clientDiscount->disc_perc = '?????';
                } else
                    $clientDiscount->disc_perc = 0;
                array_push($clientDisc, $clientDiscount);
            }
            $branchTotal = new BranchTotal();
            $branchTotal->id = $branch->id;
            $branch = Branch::where('id', '=', $branch->id)->first();
            $branchTotal->branch_name = $branch->description;
            $branchTotal->amount = $branch_amt;
            $branchTotal->cost = $branch_cost;
            $branchTotal->discount = $branch_discount;
            if ($branch_amt != 0)
                $branchTotal->discount_perc = ($branch_discount * -1) / $branch_amt * 100;
            else
                $branchTotal->discount_perc = 0;
            array_push($branchArray, $branchTotal);
        }
        return view('reports.ClientDiscountReport', compact('start_date', 'end_date', 'branchArray', 'clientDisc'));
    }
    public function consultations()
    {
        $type = UserType::where('type', '=', 'V')->first();
        $users = Vetuser::where('id', '>', 0)
            ->where('usertype_id', '=', $type->id)->orderBy('user_name', 'asc')->get();
        $branches = Branch::where('id', '!=', null)
            ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();

        return view('reports.TotalConsultations', compact('users', 'branches'));
    }
    public function consultationsReport(Request $request)
    {
        ini_set('max_execution_time', '-1');
        if ($request->end_date < $request->start_date)
            return Redirect::route('TotalConsultations')->withInput()->with('danger', 'End Date cannot be less than Start Date');

        if ($request->branch_id == null)
            $branches = Branch::where('id', '!=', null)
                ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();
        else
            $branches = Branch::where('id', '=', $request->branch_id)->get();

        $pieces = array_filter(explode("&", $_SERVER['QUERY_STRING']));
        $params = array();
        foreach ($pieces as $param) {
            list($name, $value) = explode('=', $param, 2);
            $params[urldecode($name)][] = urldecode($value);
        }
        $type = UserType::where('type', '=', 'V')->first();
        $vetsQuery = Vetuser::where('id', '>', 0)
            ->where('usertype_id', '=', $type->id);
        if ($request->user_id != null) {
            if (count($params) > 0) {
                if (array_key_exists("user_id", $params)) {
                    if (array_key_exists("user_id", $params))
                        $vetsQuery = $vetsQuery->wherein('id', $params["user_id"]);
                }
            }
        }
        $vets = $vetsQuery->get();
        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::find($user->eid_id);
        $schemaName = $eid->schemaName;
        $start_date = date('d/m/Y', strtotime($request->start_date));
        $end_date = date('d/m/Y', strtotime($request->end_date));
        $date = Carbon::now();
        $totalConsult = array();
        $branchArray = array();
        $vetArray = array();
        $grand_amount = 0;
        $grand_discount = 0;
        $grand_cost = 0;
        $grand_tax = 0;
        if ($request->print_detail == 'on') {
            foreach ($branches as $branch) {
                $branch_amount = 0;
                $branch_discount = 0;
                $branch_cost = 0;
                $branch_tax = 0;
                foreach ($vets as $vet) {
                    $sql = ("select branch_id, salesman, invnum, sum(amount) AS amount, sum(discount) AS discount, sum(tax)
                        AS tax, sum(cost) AS cost from $schemaName.invoice where invoice_date >= '$request->start_date' and
                        invoice_date <= '$request->end_date' and salesman = '$vet->user_code' and branch_id = '$branch->id'
                        GROUP BY branch_id, salesman, invnum ORDER BY branch_id, salesman, invnum ASC");
                    $invoices = DB::select($sql);

                    $vet_amount = 0;
                    $vet_discount = 0;
                    $vet_cost = 0;
                    $vet_tax = 0;
                    foreach ($invoices as $invoice) {
                        if ($invoice->salesman == null or $invoice->salesman == "  " or $invoice->amount == 0)
                            continue;

                        $totalConsultation = new TotalConsultations();
                        $totalConsultation->branch_id = $invoice->branch_id;
                        $totalConsultation->vet_id = $invoice->salesman;
                        $userName = Vetuser::where('user_code', '=', $invoice->salesman)->first();
                        $totalConsultation->vetUser = $userName->user_name;
                        $totalConsultation->invoice_no = $invoice->invnum;
                        $totalConsultation->amount = $invoice->amount;
                        $totalConsultation->discount = $invoice->discount;
                        $totalConsultation->tax = $invoice->tax;
                        $totalConsultation->cost = $invoice->cost;
                        array_push($totalConsult, $totalConsultation);
                        $vet_amount = $vet_amount + $invoice->amount;
                        $vet_discount = $vet_discount + $invoice->discount;
                        $vet_cost = $vet_cost + $invoice->cost;
                        $vet_tax = $vet_tax + $invoice->tax;
                    }
                    if ($vet_amount > 0) {
                        $vetTotals = new VetTotalConsult();
                        $vetTotals->branch_id = $branch->id;
                        $vetTotals->vet_code = $vet->user_code;
                        $vetTotals->vet_user = $userName->user_name;
                        $vetTotals->tot_amount = $vet_amount;
                        $vetTotals->tot_discount = $vet_discount;
                        $vetTotals->tot_cost = $vet_cost;
                        $vetTotals->tot_tax = $vet_tax;
                        array_push($vetArray, $vetTotals);
                    }
                    $branch_amount = $branch_amount + $vet_amount;
                    $branch_discount = $branch_discount + $vet_discount;
                    $branch_cost = $branch_cost + $vet_cost;
                    $branch_tax = $branch_tax + $vet_tax;
                }
                if ($branch_amount > 0) {
                    $branchTotals = new BranchTotalConsult();
                    $branchTotals->id = $branch->id;
                    $branchTotals->branch_name = $branch->description;
                    $branchTotals->tot_amount = $branch_amount;
                    $branchTotals->tot_discount = $branch_discount;
                    $branchTotals->tot_cost = $branch_cost;
                    $branchTotals->tot_tax = $branch_tax;
                    array_push($branchArray, $branchTotals);
                }
                $grand_amount = $grand_amount + $branch_amount;
                $grand_discount = $grand_discount + $branch_discount;
                $grand_cost = $grand_cost + $branch_cost;
                $grand_tax = $grand_tax + $branch_tax;
            }
            return view('reports.TotalConsultationReport', compact(
                'start_date',
                'end_date',
                'date',
                'totalConsult',
                'vetArray',
                'branchArray',
                'grand_amount',
                'grand_discount',
                'grand_cost',
                'grand_tax'
            ));
        } else {
            foreach ($branches as $branch) {
                $branch_amount = 0;
                $branch_discount = 0;
                $branch_cost = 0;
                $branch_tax = 0;
                foreach ($vets as $vet) {
                    $sql = ("select branch_id, salesman, sum(amount) as amount, sum(discount) as discount, sum(tax) as tax,
                    sum(cost) as cost from $schemaName.invoice where invoice_date >= '$request->start_date' and
                    invoice_date <= '$request->end_date' and salesman = '$vet->user_code' and branch_id =
                    '$branch->id' GROUP BY branch_id, salesman ORDER BY salesman ASC");
                    $invoices = DB::select($sql);

                    $tot_amount = 0;
                    $tot_discount = 0;
                    $tot_tax = 0;
                    $tot_cost = 0;
                    foreach ($invoices as $invoice) {
                        if ($invoice->salesman == "  ")
                            continue;
                        $totalConsultation = new TotalConsultations();
                        $totalConsultation->branch_id = $invoice->branch_id;
                        $userName = Vetuser::where('user_code', '=', $invoice->salesman)->first();
                        $totalConsultation->vetUser = $userName->user_name;
                        $totalConsultation->amount = $invoice->amount;
                        $totalConsultation->discount = $invoice->discount;
                        $totalConsultation->tax = $invoice->tax;
                        $totalConsultation->cost = $invoice->cost;
                        array_push($totalConsult, $totalConsultation);
                        $tot_amount = $tot_amount + $invoice->amount;
                        $tot_discount = $tot_discount + $invoice->discount;
                        $tot_cost = $tot_cost + $invoice->cost;
                        $tot_tax = $tot_tax + $invoice->tax;
                    }
                    $branch_amount = $branch_amount + $tot_amount;
                    $branch_discount = $branch_discount + $tot_discount;
                    $branch_cost = $branch_cost + $tot_cost;
                    $branch_tax = $branch_tax + $tot_tax;
                }
                $branchTotals = new BranchTotalConsult();
                $branchTotals->id = $branch->id;
                $branchTotals->branch_name = $branch->description;
                $branchTotals->tot_amount = $branch_amount;
                $branchTotals->tot_discount = $branch_discount;
                $branchTotals->tot_cost = $branch_cost;
                $branchTotals->tot_tax = $branch_tax;
                array_push($branchArray, $branchTotals);
                $grand_amount = $grand_amount + $branch_amount;
                $grand_discount = $grand_discount + $branch_discount;
                $grand_cost = $grand_cost + $branch_cost;
                $grand_tax = $grand_tax + $branch_tax;
            }
            return view('reports.TotalConsultRep2', compact(
                'start_date',
                'end_date',
                'date',
                'totalConsult',
                'branchArray',
                'grand_amount',
                'grand_discount',
                'grand_cost',
                'grand_tax'
            ));
        }
    }
    public function topClient()
    {
        $branches = Branch::where('id', '!=', null)
            ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();

        return view('reports.TopClient', compact('branches'));
    }
    public function topClientReport(Request $request)
    {
        ini_set('max_execution_time', '-1');
        if ($request->end_date < $request->start_date)
            return Redirect::route('TopClient')->withInput()->with('danger', 'End Date cannot be less than Start Date');

        if ($request->branch_id == null) {
            $branches = Branch::where('id', '!=', null)->orderBy('description', 'asc')->get();
            $branch_name = 'ALL BRANCHES';
        } else {
            $branches = Branch::where('id', '=', $request->branch_id)->get();
            $branch = Branch::where('id', '=', $request->branch_id)->first();
            $branch_name = $branch->description;
        }
        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();

        $eid = EID::find($user->eid_id);
        $name = $eid->schemaName;
        DB::table($name . '.' . 'top_customer')->truncate();
        $date = Carbon::now();
        $t_amt = 0;
        $t_rec = 0;
        $t_int = 0;
        $t_adj = 0;
        $customer = null;
        $cnt = 0;
        foreach ($branches as $branch) {
            $sql = ("select c.customer, tran_type, active, sum(amount) as amount, sum(vat) as vat from $name.clients c,
                $name.domtra d where c.branch_id = '$branch->id' and  c.customer = d.customer and c.branch_id = d.branch_id
                and dtra_date >= '$request->start_date' and dtra_date <= '$request->end_date' group by c.customer, tran_type");
            $clients = DB::select($sql);
            foreach ($clients as $client) {
                if ($request->ignoreInactiveAccounts == 'on' && $client->active == 'N')
                    continue;
                if ($request->ignoreSystemAccounts == 'on') {
                    if (
                        $client->customer == $branch->stray_acc or $client->customer == $branch->buy_aid_acc or
                        $client->customer == $branch->cash_sale_acc1 or $client->customer == $branch->cash_sale_acc2 or
                        $client->customer == $branch->cash_sale_acc3
                    )
                        continue;
                }
                if ($client->customer != $customer and $customer != null) {
                    $topCustomer = new TopCustomer();
                    $cust = Client::where('customer', '=', $customer)->first();
                    $topCustomer->name = $cust->initials . ' ' . $cust->surname;
                    $topCustomer->created_date = Carbon::now();
                    $topCustomer->sales = $t_amt;
                    $topCustomer->receipts = $t_rec;
                    $topCustomer->adjustments = $t_adj;
                    $topCustomer->interests = $t_int;
                    $dateDiff = Carbon::now()->diff($cust->last_seen);
                    $topCustomer->noofdays = $dateDiff->days;
                    $topCustomer->last_seen = $cust->last_seen;
                    $topCustomer->customer = $cust->customer;
                    $topCustomer->branch_id = $branch->id;
                    $topCustomer->save();
                    $cnt = $cnt + 1;
                    $t_amt = 0;
                    $t_rec = 0;
                    $t_int = 0;
                    $t_adj = 0;
                }
                switch ($client->tran_type) {
                    case 'FWD':
                        break;
                    case 'INV':
                        $t_amt = $client->amount + $client->vat;
                        break;
                    case 'CAL':
                        $t_rec = $client->amount + $client->vat;
                        break;
                    case 'INT':
                        $t_int = $client->amount + $client->vat;
                        break;
                    default:
                        $t_adj = $client->amount + $client->vat;
                }
                $customer = $client->customer;
            }
            if ($t_amt > 0) {
                $topCustomer = new TopCustomer();
                $cust = Client::where('customer', '=', $customer)->first();
                $topCustomer->name = $cust->initials . ' ' . $cust->surname;
                $topCustomer->created_date = Carbon::now();
                $topCustomer->sales = $t_amt;
                $topCustomer->receipts = $t_rec;
                $topCustomer->adjustments = $t_adj;
                $topCustomer->interests = $t_int;
                $dateDiff = Carbon::now()->diff($cust->last_seen);
                $topCustomer->noofdays = $dateDiff->days;
                $topCustomer->last_seen = $cust->last_seen;
                $topCustomer->customer = $cust->customer;
                $topCustomer->branch_id = $branch->id;
                $topCustomer->save();
                $cnt = $cnt + 1;
            }
            $sql = ("select c.customer, tran_type, active, sum(amount) as amount, sum(vat) as vat from $name.clients c,
                $name.domtram d where c.branch_id = '$branch->id' and  c.customer = d.customer and c.branch_id = d.branch_id
                and mdtra_date >= '$request->start_date' and mdtra_date <= '$request->end_date' group by c.customer, tran_type");
            $clients = DB::select($sql);
            foreach ($clients as $client) {
                if ($request->ignoreInactiveAccounts == 'on' && $client->active == 'N')
                    continue;
                if ($request->ignoreSystemAccounts == 'on') {
                    if (
                        $client->customer == $branch->stray_acc or $client->customer == $branch->buy_aid_acc or
                        $client->customer == $branch->cash_sale_acc1 or $client->customer == $branch->cash_sale_acc2 or
                        $client->customer == $branch->cash_sale_acc3
                    )
                        continue;
                }
                if ($client->customer != $customer and $customer != null) {
                    $topCustomer = new TopCustomer();
                    $cust = Client::where('customer', '=', $customer)->first();
                    $topCustomer->name = $cust->initials . ' ' . $cust->surname;
                    $topCustomer->created_date = Carbon::now();
                    $topCustomer->sales = $t_amt;
                    $topCustomer->receipts = $t_rec;
                    $topCustomer->adjustments = $t_adj;
                    $topCustomer->interests = $t_int;
                    $dateDiff = Carbon::now()->diff($cust->last_seen);
                    $topCustomer->noofdays = $dateDiff->days;
                    $topCustomer->last_seen = $cust->last_seen;
                    $topCustomer->customer = $cust->customer;
                    $topCustomer->branch_id = $branch->id;
                    $topCustomer->save();
                    $cnt = $cnt + 1;
                    $t_amt = 0;
                    $t_rec = 0;
                    $t_int = 0;
                    $t_adj = 0;
                }
                switch ($client->tran_type) {
                    case 'FWD':
                        break;
                    case 'INV':
                        $t_amt = $client->amount + $client->vat;
                        break;
                    case 'CAL':
                        $t_rec = $client->amount + $client->vat;
                        break;
                    case 'INT':
                        $t_int = $client->amount + $client->vat;
                        break;
                    default:
                        $t_adj = $client->amount + $client->vat;
                }
                $customer = $client->customer;
            }
            if ($t_amt > 0) {
                $topCustomer = new TopCustomer();
                $cust = Client::where('customer', '=', $customer)->first();
                $topCustomer->name = $cust->initials . ' ' . $cust->surname;
                $topCustomer->created_date = Carbon::now();
                $topCustomer->sales = $t_amt;
                $topCustomer->receipts = $t_rec;
                $topCustomer->adjustments = $t_adj;
                $topCustomer->interests = $t_int;
                $dateDiff = Carbon::now()->diff($cust->last_seen);
                $topCustomer->noofdays = $dateDiff->days;
                $topCustomer->last_seen = $cust->last_seen;
                $topCustomer->customer = $cust->customer;
                $topCustomer->branch_id = $branch->id;
                $topCustomer->save();
                $cnt = $cnt + 1;
            }
        }
        $topCustomer = TopCustomer::where('id', '>', 0)->orderBy('sales', 'desc')->get();
        return view('reports.TopClientReport', compact('branch_name', 'date', 'topCustomer', 'cnt'));
    }
    public function stockTaking()
    {
        $warehouses = Warehouse::where('id', '>', 0)->orderBy('name', 'asc')->get();
        $types = Type::where('id', '>', 0)->orderBy('description', 'asc')->get();

        return view('reports.StockTaking', compact('warehouses', 'types'));
    }
    public function stockTakingReport(Request $request)
    {
        if ($request->letterRanges == 'on') {
            if ($request->startLetter == null or $request->endLetter == null)
                return Redirect::route('StockTaking')->withInput()
                    ->with('danger', 'Start and End Letter cannot be null if Use Letter Ranges is ticked');
        } else {
            if ($request->startLetter != null or $request->endLetter != null)
                return Redirect::route('StockTaking')->withInput()
                    ->with('danger', 'Start and End Letter must be null if Use Letter Ranges is not ticked');
        }
        $startLength = Str::length($request->startLetter);
        $endLength = Str::length($request->endLetter);
        if ($startLength > 1 or $endLength > 1)
            return Redirect::route('StockTaking')->withInput()
                ->with('danger', 'Start or End Letter cannot be more than two characters');
        if ($request->endLetter < $request->startLetter)
            return Redirect::route('StockTaking')->withInput()
                ->with('danger', 'Start Letter cannot be greater than End Letter');
        if ($request->costPrice == 'on')
            $include_prices = 'Yes';
        else
            $include_prices = 'No';

        $warehouse = Warehouse::where('id', '=', $request->warehouse_id)->first();
        $type = Type::where('id', '=', $request->type_id)->first();
        $date = Carbon::now();

        $codes = Code::where('type_id', '=', $request->type_id)->orderBy('description', 'asc')->get();
        $stockTaking = array();
        foreach ($codes as $code) {
            if ($code->code == 0 or $code->description == null or $code->description == '                              ')
                continue;
            if ($request->startLetter != null) {
                if (
                    substr($code->description, 0, 1) < $request->startLetter or substr($code->description, 0, 1) >
                    $request->endLetter
                )
                    continue;
            }
            if ($code->stkind != 'Y')
                continue;

            $stock = Stock::where('code_id', '=', $code->id)
                ->where('warehouse_id', '=', $request->warehouse_id)->first();
            if ($stock) {
                $stockTakingWorksheet = new StockTakingWorksheet();
                $stockTakingWorksheet->description = $code->description;
                $stockTakingWorksheet->uom = $code->uom;
                $stockTakingWorksheet->comp_qty = $stock->quantity_on_hand;
                $stockTakingWorksheet->counted_qty = '___________';
                $stockTakingWorksheet->adjustment_qty = '______________';
                $stockTakingWorksheet->price = $stock->cost_price;
                array_push($stockTaking, $stockTakingWorksheet);
            }
        }
        return view('reports.StockTakingReport', compact('warehouse', 'type', 'date', 'stockTaking', 'include_prices'));
    }
    public function patientsWithoutMicrochip()
    {
        $branches = Branch::where('id', '!=', null)
            ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();
        $patienttypes = PatientType::where('id', '>', 0)->orderBy('type', 'asc')->get();

        return view('reports.PatientsWithoutMicrochip', compact('patienttypes', 'branches'));
    }
    public function patientsWithoutChipReport(Request $request)
    {
        ini_set('max_execution_time', '-1');
        $user = User::where('name', '=', Auth::user()->name)
            ->where('surname', '=', Auth::user()->surname)->first();
        $eid = EID::find($user->eid_id);
        $name = $eid->schemaName;

        $branch = Branch::where('id', '=', $request->branch_id)->first();
        $patType = PatientType::where('id', '=', $request->patType_id)->first();

        if ($request->patient_status == 'on')
            $sql = ("select p.patient, p.name, p.type, c.customer, surname from $name.patients p, $name.patient_client pt,
                $name.clients c where p.patient = pt.patient and pt.customer = c.customer and p.type = '$patType->type'
                and p.active = 'Y' and p.branch_id = '$branch->id'");
        else
            $sql = ("select p.patient, p.name, p.type, c.customer, surname from $name.patients p, $name.patient_client pt,
                $name.clients c where p.patient = pt.patient and pt.customer = c.customer and p.type  = '$patType->type'
                and p.active != 'Y' and p.branch_id = '$branch->id'");
        $patients = DB::select($sql);
        $date = Carbon::now();
        if ($request->patient_status == 'on')
            $status = 'Active Patients';
        else
            $status = 'Inactive Patients';

        $patientWithoutChip = array();
        $patientCnt = 0;
        foreach ($patients as $patient) {
            $count = Trovan::where('patient', '=', $patient->patient)->count();
            if ($count == 0) {
                $patientWithoutMicrochip = new PatientWithoutChip();
                $patientWithoutMicrochip->patient = $patient->patient;
                $patientWithoutMicrochip->patientName = $patient->name;
                $patientWithoutMicrochip->customer = $patient->customer;
                $patientWithoutMicrochip->surname = $patient->surname;
                array_push($patientWithoutChip, $patientWithoutMicrochip);
                $patientCnt = $patientCnt + 1;
            }
        }
        return view('reports.PatientWithoutChip', compact(
            'date',
            'patType',
            'status',
            'patientWithoutChip',
            'patientCnt',
            'branch'
        ));
    }
    public function stockTransaction()
    {
        $trans = TransactionType::where('id', '>', 0)->orderBy('description', 'asc')->get();
        $subtrans = SubTransactionType::where('id', '>', 0)->orderBy('description', 'asc')->get();
        $warehouses = Warehouse::where('id', '>', 0)->orderBy('name', 'asc')->get();
        $types = Type::where('id', '>', 0)->orderBy('description', 'asc')->get();
        $codes = Code::where('id', '>', 0)->orderBy('description', 'asc')->get();
        $suppliers = Supplier::where('id', '>', 0)->orderBy('name', 'asc')->get();
        $branches = Branch::where('id', '!=', null)
            ->where('id', '!=', 'A')->orderBy('description', 'asc')->get();

        return view('reports.StockTransactions', compact(
            'warehouses',
            'types',
            'codes',
            'suppliers',
            'branches',
            'trans',
            'subtrans'
        ));
    }
    /**
     * Ajax call to return all sub transactions
     *
     * @return Code
     */
    public function ajaxTrans($tran_type)
    {
        $subtrans = SubTransactionType::where('trantype_id', '=', $tran_type)->orderBy('description', 'asc')->get();
        return $subtrans;
    }
    public function stockTransactionReport(Request $request)
    {
        ini_set('max_execution_time', '-1');
        if ($request->end_date < $request->start_date)
            return Redirect::route('StockTransaction')->withInput()->with('danger', 'End Date cannot be less than Start Date');

        if ($request->warehouse_id == null)
            $warehouse = 'ALL WAREHOUSES';
        else {
            $warehs = Warehouse::where('id', '=', $request->warehouse_id)->first();
            $warehouse = $warehs->name;
        }
        if ($request->branch_id == null)
            $branch = 'ALL BRANCHES';
        else {
            $br = Branch::where('id', '=', $request->branch_id)->first();
            $branch = $br->description;
        }
        $start_date = date('d/m/Y', strtotime($request->start_date));
        $end_date = date('d/m/Y', strtotime($request->end_date));
        $date = Carbon::now();
        $tranType = TransactionType::where('id', '=', $request->tran_type)->first();
        $transaction = $tranType->description;

        $stktraBuild = Stktra::where('stra_date', '>=', $request->start_date)
            ->where('stra_date', '<=', $request->end_date)
            ->where('trans_type', '=', $tranType->type);

        if ($request->sub_tran != null) {
            $subTran = SubTransactionType::where('id', '=', $request->sub_tran)->first();
            $sub_transaction = $subTran->description;
            $stktraBuild = $stktraBuild->where('sub_type', '=', $subTran->type);
        } else
            $sub_transaction = 'ALL SUB TYPES';

        if ($request->type_id != null) {
            $stktraBuild = $stktraBuild->where('type_id', '=', $request->type_id);
            $t = Type::where('id', '=', $request->type_id)->first();
            $type = $t->description;
        } else
            $type = 'ALL TYPES';

        if ($request->code_id != null) {
            $stktraBuild = $stktraBuild->where('code_id', '=', $request->code_id);
            $cd = Code::where('id', '=', $request->code_id)->first();
            $code = $cd->description;
        } else
            $code = 'ALL CODES';

        if ($request->supplier_id != null) {
            $stktraBuild = $stktraBuild->where('supplier', '=', $request->supplier_id);
            $sup = Supplier::where('id', '=', $request->supplier_id)->first();
            $supplier = $sup->name;
        } else
            $supplier = 'ALL SUPPLIERS';

        if ($request->manufacturer != null) {
            $stktraBuild = $stktraBuild->where('supplier', '=', $request->manufacturer);
            $sup = Supplier::where('id', '=', $request->manufacturer)->first();
            $manufacturer = $sup->name;
        } else
            $manufacturer = 'ALL MANUFACTURERS';

        $trans = $stktraBuild->orderBy('stra_date', 'asc')->orderBy('sub_type', 'asc')->get();
        $stktras = array();
        foreach ($trans as $tran) {
            $storeStktra = new StoreStktra();
            $storeStktra->date = date('d/m/Y', strtotime($tran->stra_date));
            $storeStktra->description = $tran->description;
            $storeStktra->rep = $tran->salesman;
            $storeStktra->source_pgm = $tran->source_prgm;
            $storeStktra->warehs = $tran->loc_to;
            $sub = SubTransactionType::where('type', '=', $tran->sub_type)->first();
            $storeStktra->sub_trans = $sub->description;
            $suppl = Supplier::where('supplier_no', '=', $tran->supplier)->first();
            if ($suppl) {
                $storeStktra->supplierName = $suppl->name;
            }
            $storeStktra->supplier_invno = $tran->sup_inv;
            if ($tran->trans_type == 'ADJ') {
                switch ($tran->sub_type) {
                    case 'MUP':
                        $storeStktra->old_value = $tran->old_markup;
                        $storeStktra->new_value = $tran->new_markup;
                        $storeStktra->adj_qty = $tran->old_markup - $tran->new_markup;
                        break;
                    case 'CPC':
                        $storeStktra->old_value = $tran->old_cost_price;
                        $storeStktra->new_value = $tran->new_cost_price;
                        $storeStktra->adj_qty = $tran->old_cost_price - $tran->new_cost_price;
                        break;
                    case 'SPC':
                        $storeStktra->old_value = $tran->old_sales_price;
                        $storeStktra->new_value = $tran->new_sales_price;
                        $storeStktra->adj_qty = $tran->old_sales_price - $tran->new_sales_price;
                        break;
                    case 'REO':
                        $storeStktra->old_value = $tran->old_reorder;
                        $storeStktra->new_value = $tran->new_reorder;
                        $storeStktra->adj_qty = $tran->old_reorder - $tran->new_reorder;
                        break;
                    case 'MIN':
                        $storeStktra->old_value = $tran->old_amt;
                        $storeStktra->new_value = $tran->new_amt;
                        $storeStktra->adj_qty = $tran->old_amt - $tran->new_amt;
                        break;
                    case 'DUL':
                        $storeStktra->old_value = $tran->old_amt;
                        $storeStktra->new_value = $tran->new_amt;
                        $storeStktra->adj_qty = $tran->old_amt - $tran->new_amt;
                        break;
                    case 'MUL':
                        $storeStktra->old_value = $tran->old_amt;
                        $storeStktra->new_value = $tran->new_amt;
                        $storeStktra->adj_qty = $tran->old_amt - $tran->new_amt;
                        break;
                    case 'QTY':
                        $storeStktra->adj_qty = $tran->new_qty_onhand - $tran->old_qty_onhand;
                        $s_diff = $storeStktra->adj_qty * $tran->new_sales_price;
                        $c_diff = $storeStktra->adj_qty * $tran->new_cost_price;
                        $storeStktra->old_value = $tran->old_qty_onhand;
                        $storeStktra->new_value = $tran->new_qty_onhand;
                        $storeStktra->cost_value = $c_diff;
                        $storeStktra->sell_value = $s_diff;
                        break;
                    case 'RET':
                        $storeStktra->old_value = $tran->old_qty_onhand;
                        $storeStktra->new_value = $tran->new_qty_onhand;
                        $storeStktra->adj_qty = $tran->new_qty_onhand - $tran->old_qty_onhand;
                        break;
                    case 'TRF':
                        $storeStktra->old_value = $tran->old_qty_onhand;
                        $storeStktra->new_value = $tran->new_qty_onhand;
                        $storeStktra->adj_qty = $tran->new_qty_onhand - $tran->old_qty_onhand;
                        break;
                }
            } else {
                $storeStktra->old_value = $tran->adjust_qty;
                $storeStktra->new_value = $tran->tot_purch;
                $storeStktra->old_qty = $tran->old_qty_onhand;
                $storeStktra->new_qty = $tran->new_qty_onhand;
                $storeStktra->old_cost_price = $tran->old_cost_price;
                $storeStktra->new_cost_price = $tran->new_cost_price;
                $storeStktra->old_sales_price = $tran->old_sales_price;
                $storeStktra->new_sales_price = $tran->new_sales_price;
            }
            array_push($stktras, $storeStktra);
        }
        if ($tranType->type == 'ADJ')
            return view('reports.StockTransADJRep', compact(
                'transaction',
                'sub_transaction',
                'branch',
                'warehouse',
                'type',
                'code',
                'supplier',
                'manufacturer',
                'start_date',
                'end_date',
                'date',
                'stktras'
            ));
        else
            return view('reports.StockTransRECRep', compact(
                'transaction',
                'sub_transaction',
                'branch',
                'warehouse',
                'type',
                'code',
                'supplier',
                'manufacturer',
                'start_date',
                'end_date',
                'date',
                'stktras'
            ));
    }
}
class NewClients
{
    public $day;
    public $date;
    public $clientsCount;
    public $patientsCount;
}
class DebtorsAge
{
    public $customer;
    public $surname;
    public $initials;
    public $telNo;
    public $mobileNo;
    public $lastPmtDate;
    public $lastPmtAmt;
    public $current;
    public $days30;
    public $days60;
    public $days90;
    public $days120;
    public $total;
}
class VetconReport
{
    public $branch;
    public $vet;
    public $invoice;
    public $amount;
    public $discount;
    public $vat;
    public $total;
}
class VetconTotals
{
    public $user_name;
    public $count;
    public $averageAmt;
    public $averageDisc;
    public $averageVAT;
    public $averageTotal;
}
class StockItemUsage
{
    public $warehouse;
    public $usage_date;
    public $usage_time;
    public $user;
    public $client;
    public $invoice;
    public $qty;
    public $amount;
    public $discount;
}
class BanksumSummary
{
    public $paymentType;
    public $amount;
    public $discount;
}
class BanksumDetails
{
    public $paymentType;
    public $customer;
    public $surname;
    public $reference;
    public $bank_date;
    public $amount;
    public $discount;
}
class TillCashup
{
    public $description;
    public $tillNo;
    public $till_date;
    public $customer;
    public $initials;
    public $surname;
    public $amount;
}
class StockValuation
{
    public $typeDesc;
    public $warehouse;
    public $description;
    public $uom;
    public $qty_oh;
    public $cost_price;
    public $sales_price;
}
class TypesArray
{
    public $type_id;
    public $description;
    public $cost_price;
    public $sales_price;
}
class WarehouseTotal
{
    public $name;
    public $type_id;
    public $cost_price;
    public $sales_price;
}
class GrandTotal
{
    public $name;
    public $cost_price;
    public $sales_price;
}
class PatientStatus
{
    public $branch_id;
    public $patient;
    public $patientName;
    public $dob;
    public $breed;
    public $takeon_date;
    public $dod;
}
class LastSeenClients
{
    public $branch_id;
    public $customer;
    public $clientName;
    public $hometel;
    public $mobile;
    public $email;
    public $takeon_date;
    public $last_seen;
}
class BranchTotal
{
    public $id;
    public $branch_name;
    public $total;
    public $cost;
    public $amount;
    public $discount;
    public $discount_perc;
}
class ClientDiscount
{
    public $branch;
    public $customer;
    public $invoice;
    public $inv_date;
    public $type;
    public $reference;
    public $user;
    public $cost;
    public $amount;
    public $discount;
    public $disc_perc;
}
class TotalConsultations
{
    public $branch_id;
    public $vet_id;
    public $vetUser;
    public $invoice_no;
    public $amount;
    public $discount;
    public $cost;
    public $tax;
}
class VetTotalConsult
{
    public $branch_id;
    public $vet_code;
    public $vet_user;
    public $tot_amount;
    public $tot_discount;
    public $tot_cost;
    public $tot_tax;
}
class BranchTotalConsult
{
    public $branch_id;
    public $branch_name;
    public $tot_amount;
    public $tot_discount;
    public $tot_cost;
    public $tot_tax;
}
class StockTakingWorksheet
{
    public $description;
    public $uom;
    public $comp_qty;
    public $counted_qty;
    public $adjustment_qty;
    public $price;
}
class ClientInformation
{
    public $customer;
    public $title;
    public $surname;
    public $firstnames;
    public $id_number;
    public $address1;
    public $address2;
    public $address3;
    public $code;
    public $hometel;
    public $cell2;
    public $email;
}
class PatientWithoutChip
{
    public $patient;
    public $patientName;
    public $customer;
    public $surname;
}
class StoreStktra
{
    public $sub_trans;
    public $date;
    public $description;
    public $rep;
    public $source_pgm;
    public $warehs;
    public $old_value;
    public $new_value;
    public $adj_qty;
    public $value;
    public $return;
    public $purchase_price;
    public $old_qty;
    public $new_qty;
    public $old_cost_price;
    public $new_cost_price;
    public $old_sales_price;
    public $new_sales_price;
    public $supplierName;
    public $supplier_invno;
    public $cost_value;
    public  $sell_value;
}
