<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Client extends Model
{
    use HasFactory;

    public function __construct()
    {
        $this->connection = \Session::get('connectionName');
    }

    public $incrementing = false;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'clients';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['customer', 'surname', 'initials', 'title', 'firstnames', 'id_number', 'address1', 'address2',
        'address3', 'code', 'hometel', 'cell2', 'paddress1', 'paddress2', 'paddress3', 'pcode', 'balance', 'ytd_amt',
        'lastyr_sales', 'last_pmt', 'next_pmt', 'interest', 'statement', 'bad_dr', 'bal_type', 'salesman', 'last_pmt_amt',
        'reg_vendor', 'tax_number', 'xray', 'reminders', 'current', 'age30', 'age60', 'age90', 'age120', 'disc_cat',
        'language', 'operator', 'agri_vat', 'contract', 'buy_aid', 'income', 'fax', 'work_ref', 'cell1', 'work_tel',
        'account_fee', 'email', 'rel_name', 'reladdr1', 'reladdr2', 'reladdr3', 'relcode', 'reltel', 'last_mod', 'active',
        'last_seen', 'xfield', 'pn_flag', 'newsletter', 'mail', 'takeon_date', 'pref_vet', 'extra_id', 'hosp_case', 'appoint',
        'mileage', 'interest_pct', 'last_mod_user', 'cell1_owner', 'cell1_use_sms', 'cell1_info', 'cell2_owner',
        'cell2_use_sms', 'cell2_info', 'branch_id'];
}
