<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    use HasFactory;

    public function __construct()
    {
        $this->connection = \Session::get('connectionName');
    }

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'invoice';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['invnum', 'line', 'itemcat', 'item', 'description', 'qty_shipped', 'uom', 'salesman', 'invoice_date',
        'amount', 'discount', 'tax', 'cost', 'bkord', 'disc_type', 'combo_inv_det', 'inj_line', 'disp_fee', 'promo',
        'mini_combo_detail', 'combo_code', 'mini_combo_code', 'is_a_combo', 'combo_type', 'mini_combo_type', 'is_combo_line',
        'is_mini_combo', 'is_mini_combo_line', 'is_combo_header', 'is_mini_combo_header', 'combo_amt', 'combo_vat', 'combo_dis',
        'combo_magic', 'mini_magic', 'combo_line_no', 'info_line_no', 'combo_cost', 'neg_stock_sale', 'combo_allow_price_chg',
        'combo_allow_qty_chg', 'batch', 'inj_count', 'customer', 'patient', 'branch_id', 'warehouse_id'];
}
