@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')
<!-- DataTables -->
<link href="{{ URL::asset('/assets/libs/jquery-vectormap/jquery-vectormap.min.css')}}" rel="stylesheet"
    type="text/css" />
<!-- Responsive datatable examples -->
<link href="{{ URL::asset('/assets/libs/datatables/datatables.min.css')}}" rel="stylesheet" type="text/css" />
<link href="https://cdn.jsdelivr.net/npm/remixicon@2.5.0/fonts/remixicon.css" rel="stylesheet">
<link href="https://code.iconify.design/1/1.0.7/iconify.min.js" rel="stylesheet">

<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>


@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Dashboard @endslot
@slot('li_1') Vetsoft @endslot
@endcomponent

<!-- row first begin -->
<div class="row">
    <div class="col-xl-12 grid-margin stretch-card">
        <div class="card">

            <div class="card-body">

                <div class="float-right">
                    <h6> <label for="month">Month:</label>
                        <input class="input-xs
                        form-control-xs" id="month" type="text" name="month" placeholder="{{ $selected_date }}"
                            onfocus="(this.type='month')">
                    </h6>
                </div>
                <div class="float-left">
                    <h6> <label for="month">Date:</label>
                        {{ $create_date }}
                    </h6>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- row first end-->

<!-- row 2nd begin - 2x charts -->
<div class="row">
    <div class="col-xl-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <div class="dropdown float-right mt-n2">

                    <a class="btn" href="{!!URL::route('TotalConsultations')!!}" role="button"><i
                            class="ri-search-eye-line ri-lg" data-toggle="tooltip" data-placement="top"
                            title="Search All Daily Consultations"></i></a>
                    <a class="btn"
                        href="{{route('TotalConsultReport', ['start_date'=> $start_date, 'end_date'=> $end_date, 'print_detail'=> 'on', 'branch_id'=> '']) }}"
                        role="button"><i class="ri-eye-line ri-lg " data-toggle="tooltip" data-placement="top"
                            title="Show All Daily Consultations"></i></a>

                </div>

                <h4 class="card-title mb-4">All Daily Consultations</h4>



                <div>
                    {!! $consultationChart->container() !!}

                    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.7.1/Chart.min.js"></script>

                    {!! $consultationChart->script() !!}
                </div>
            </div>
            <!--end card-->
        </div>
    </div>
    <div class="col-xl-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">

                <div class="dropdown float-right mt-n2">

                    <a class="btn" href="{!!URL::route('SalesByType')!!}" role="button"><i
                            class="ri-search-eye-line ri-lg" data-toggle="tooltip" data-placement="top"
                            title="Search Stock Movement"></i></a>
                    <a class="btn"
                        href="{{route('SalesReportByType', ['start_date'=> $start_date, 'end_date'=> $end_date, 'type_indicator'=> 'on']) }}"
                        role="button"><i class="ri-eye-line ri-lg " data-toggle="tooltip" data-placement="top"
                            title="Show Stock Movement"></i></a>
                </div>

                <h4 class="card-title mb-4">Stock Movement</h4>
                <div>
                    <div>
                        {!! $stockChart->container() !!}

                        <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.7.1/Chart.min.js"></script>

                        {!! $stockChart->script() !!}
                    </div>
                </div>
            </div>
        </div>
        <!--end card-->
    </div>
</div>
<!-- end 2nd row -->

<!-- row 3rd begin - 1 stretch chart -->
<div class="row">
    <div class="col-xl-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">

                <div class="dropdown float-right mt-n2">
                    <a class="btn" href="{!!URL::route('SalesByType')!!}" role="button"><i
                            class="ri-search-eye-line ri-lg" data-toggle="tooltip" data-placement="top"
                            title="Search Daily Sales Report"></i></a>
                    <a class="btn"
                        href="{{route('SalesReportByType', ['start_date'=> $start_date, 'end_date'=> $end_date, 'type_indicator'=> 'on']) }}"
                        role="button"><i class="ri-eye-line ri-lg " data-toggle="tooltip" data-placement="top"
                            title="Show Daily Sales Report"></i></a>
                </div>

                <h4 class="card-title mb-4">Daily Sales</h4>
                <div>
                    {!! $saleChart->container() !!}

                    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.7.1/Chart.min.js"></script>

                    {!! $saleChart->script() !!}

                </div>
            </div>
        </div>
    </div>
</div>
<!-- row 3rd end - 1 stretch chart -->

<script>
    $("#month").on('change', function () {
            var value = $('#month').val();
            let url = "{{ route('dashboard', ':id') }}";
            url = url.replace(':id', value);
            document.location.href=url;
        });
        var url = window.location.href;
        var parts = url.split("/");
        var date = parts[parts.length - 1];
        $("#month").val(date);
</script>

@endsection
