<!-- app/views/reports/AverageConsults.blade.php -->

@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Average Invoice Value By Vet @endslot
@slot('li_1') @endslot
@endcomponent

<!-- Create Average Consult Search Form... -->

<div class="row">
    <div class="col-xl-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                {!! HTML::ul($errors->all()) !!}

                {!! Form::open(array('route' => 'AverageConsultsByVet', 'method'=>'GET','files'=>true)) !!}

                <div class="col-sm-8 col-md-8">

                    <div class="form-group">
                        {!! Form::label('start_date', 'Start Date') !!}
                        {!! Form::date('start_date', Request::old('start_date'), array('class' => 'form-control input-sm
                        form-control-sm', 'required', 'id'=>'start_date')) !!}
                    </div>

                    <div class="form-group">
                        {!! Form::label('end_date', 'End Date') !!}
                        {!! Form::date('end_date', Request::old('end_date'), array('class' => 'form-control
                        form-control-sm', 'required', 'id'=>'end_date')) !!}
                    </div>

                    <div class="form-group">
                        {!! Form::Label('user_code', 'User Name') !!}
                        <select class="form-control input-sm form-control-sm" name="user_code" id="user_code" multiple>
                            <option value="">All Users</option>
                            @foreach($reps as $rep)
                            <option value="{{$rep->user_code}}" @if(old('user_code')==$rep->user_code)
                                selected="selected"@endif>{{$rep->user_code}} {{$rep->user_name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::Label('branch_id', 'Branch') !!}
                        <select class="form-control input-sm form-control-sm" name="branch_id" id="branch_id">
                            <option value="">All Branches</option>
                            @foreach($branches as $branch)
                            <option value="{{$branch->id}}" @if(old('branch_id')==$branch->id)
                                selected="selected"@endif>{{$branch->description}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="detail_report" name="detail_report">
                        <label for="detail_report"> Detail Report</label><br>
                    </div>

                </div>

                <div class="col-xs-12 col-sm-12 col-md-12">
                    {!! Form::submit('Submit', array('class' => 'btn btn-sm btn-primary')) !!}
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>


</div>

@endsection
