<!-- app/views/reports/IndividualStock.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')
@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Individual Stock Item Usage @endslot
@slot('li_1') @endslot
@endcomponent

<!-- Create Individual Stock Search Form... -->
<div class="row">
    <div class="col-xl-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">

                {!! HTML::ul($errors->all()) !!}
                {!! Form::open(array('route' => 'IndividualStockItem', 'method'=>'GET','files'=>true)) !!}

                <div class="col-sm-8 col-md-8">

                    <div class="form-group">
                        {!! Form::Label('warehouse_id', 'Warehouse') !!}
                        <select class="form-control input-sm form-control-sm" required name="warehouse_id"
                            id="warehouse_id">
                            <option value="">Select Warehouse</option>
                            @foreach($warehouses as $warehouse)
                            <option value="{{$warehouse->id}}" @if(old('warehouse_id')==$warehouse->id)
                                selected="selected"@endif>{{$warehouse->name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::label('start_date', 'Start Date') !!}
                        {!! Form::date('start_date', Request::old('start_date'), array('class' => 'form-control input-sm
                        form-control-sm', 'required', 'id'=>'start_date')) !!}
                    </div>

                    <div class="form-group">
                        {!! Form::label('end_date', 'End Date') !!}
                        {!! Form::date('end_date', Request::old('end_date'), array('class' => 'form-control
                        form-control-sm', 'required', 'id'=>'end_date')) !!}
                    </div>

                    <div class="form-group">
                        {!! Form::Label('type_id', 'System Type') !!}
                        <select class="form-control input-sm form-control-sm" required name="type_id" id="type_id">
                            <option disabled selected hidden>Select Type</option>
                            @foreach($types as $type)
                            <option value="{{$type->id}}" @if(old('type_id')==$type->id)
                                selected="selected"@endif>{{$type->description}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::label('code_id', 'Stock Code') !!}
                        <select class="form-control input-sm form-control-sm" required name="code_id" id="code_id">
                            <option value="{{ old('code_id') }}">Select Type First</option>
                        </select>
                    </div>

                </div>

                <div class="col-xs-12 col-sm-12 col-md-12">
                    {!! Form::submit('Submit', array('class' => 'btn btn-sm btn-primary')) !!}
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>


</div>

@endsection
