<!-- app/views/reports/ReprintTillReport2.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Till Cashup Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="{!!URL::route('ReprintTill')!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- Create Till Cashup Report Form... -->

    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">

                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6>Operator: <strong>{{ $operator->user_name }}</strong></h6>
                        <h6>Till Ledger No: <strong>{{ $till_no }}</strong></h6>
                        <h6>Report from: <strong>{{ $start_date }}</strong> To: <strong>{{ $end_date }}</strong></h6>
                        <h6>Date Printed: <strong>{{ $date->format('d/m/Y') }}</strong></h6>
                    </div>

                    <div class="mt-4">

                        <table class="table table-striped" id="datatable">
                            @if (count($tillsCashup) > 0)
                                @foreach($payment_types as $type)
                                    <!-- Table Headings -->
                                    <thead>
                                        <th><strong>{{ $type->description }}</strong></th>
                                    </thead>
                                    <thead>
                                        <th>Date</th>
                                        <th>Till Ledger</th>
                                        <th>Customer</th>
                                        <th>Initials</th>
                                        <th>Surname</th>
                                        <th>Amount</th>
                                    </thead>

                                    @foreach ($tillsCashup as $tran)
                                        @if($tran->description != $type->description)
                                            @continue
                                        @endif

                                        <!-- Table Body -->
                                        <tbody>
                                            <tr>
                                                <!-- Date -->
                                                <td class="table-text">
                                                    <div>{{ $tran->till_date }}</div>
                                                </td>

                                                <!-- Till Ledger No -->
                                                <td class="table-text">
                                                    <div>{{ $tran->tillNo }}</div>
                                                </td>

                                                <!-- Customer -->
                                                <td class="table-text">
                                                    <div>{{ $tran->customer }}</div>
                                                </td>

                                                <!-- Initials -->
                                                <td class="table-text">
                                                    <div>{{ $tran->initials }}</div>
                                                </td>

                                                <!-- Surname -->
                                                <td class="table-text">
                                                    <div>{{ $tran->surname }}</div>
                                                </td>

                                                <!-- Amount -->
                                                <td class="table-text">
                                                    <div>{{ number_format($tran->amount, 2) }}</div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    @endforeach
                                    <tfoot></tfoot>
                                    <tfoot>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th>Sub Total</th>
                                        <th>{{ number_format($type->amount, 2) }}</th>
                                    </tfoot>
                                @endforeach
                                <tfoot>
                                    <th>Total of all Payments Received :</th>
                                    <th>{{ number_format($grand_totals, 2) }}</th>
                                </tfoot>
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection
    @push('plugin-scripts')

    <script>
        $(document).ready(function() {

    $('#datatable').DataTable( {

        "initComplete": function (settings, json) {
    $("#datatable").wrap("<div style='overflow:auto; width:100%;position:relative;'></div>");
  },

        paging: true,
        responsive: false,
        columnDefs: [ {
            targets: [ 0 ],
            orderData: [ 0, 1 ]
        }, {
            targets: [ 1 ],
            orderData: [ 1, 0 ]
        }, {
            targets: [ 4 ],
            orderData: [ 4, 0 ]
        } ],

        dom: 'lBfrtip',
        buttons: [
            'copy',
            {
                extend: 'excel',
                messageTop: 'reportHeader',
                title: 'null',
            },
            {
                extend: 'pdfHtml5',
                messageBottom: null,
                // messageTop: title,
                title: "Debtors Age Analysis Report",
                orientation: 'landscape',
                pageSize: 'LEGAL'
            },

        ]

    } );
} );

    </script>

    @section('script')

    <script src="//cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/rowreorder/1.2.8/js/dataTables.rowReorder.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

    @endsection

    @endpush
