<!-- app/views/reports/ScheduledDrugsReport.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Scheduled Drugs (By Schedule) Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="{!!URL::route('ScheduledDrugs')!!}">BACK</a>
    @endslot
    @endcomponent

    <!-- List Scheduled Drug Report Form... -->
    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">
                <div class="card-body ">


                    <div class="text-center" id="reportHeader">

                        <h6>Printed On Date: <strong>{{ $date->format('d/m/Y') }}</strong> At:
                            <strong>{{ $date->format('H:m') }}</strong></h6>
                        <h6>From: <strong>{{ $sdate }}</strong> to <strong>{{ $edate }}</strong></h6>
                        <h6>Warehouse name: <strong>{{ $warehouse->name }}</strong></h6>
                        <h6>Schedule From: <strong>{{ $sSchedule }}</strong> to
                            <strong>{{ $eSchedule }}</strong>
                        </h6>
                    </div>


                    <div class="mt-4">

                        <table class="table table-striped display" id="datatable" style="width:100%">
                            @if (count($scheduledDrugs) > 0)
                            <!-- Table Headings -->
                            <thead>
                                <th>Description</th>
                                <th>UOM</th>
                                <th>Schedule</th>
                                <th>Code</th>
                                <th>Opening Balance Date</th>
                                <th>Opening Quantity</th>
                                <th>Client</th>
                                <th>Patient</th>
                                <th>Name</th>
                                <th>Opening Date</th>
                                <th>Quantity</th>
                                <th>Balance</th>
                            </thead>

                            <!-- Table Body -->
                            <tbody>

                                @foreach ($scheduledDrugs as $sched)
                                <tr>
                                    <!-- Description -->
                                    <td class="table-text">
                                        <div>{{ $sched->description }}</div>
                                    </td>
                                    <!-- UOM -->
                                    <td class="table-text">
                                        <div>{{ $sched->uom }}</div>
                                    </td>
                                    <!-- Schedule -->
                                    <td class="table-text">
                                        <div>{{ $sched->schedule }}</div>
                                    </td>
                                    <!-- Code -->
                                    <td class="table-text">
                                        <div>{{ $sched->code }}</div>
                                    </td>
                                    <!-- Opening Balance Date -->
                                    <td class="table-text">
                                        <div>{{ $sched->stock_date }}</div>
                                    </td>
                                    <!-- Opening Quantity -->
                                    <td class="table-text">
                                        <div>{{ number_format($sched->quantity_on_hand, 2) }}</div>
                                    </td>
                                    <!-- Client -->
                                    <td class="table-text">
                                        <div>{{ $sched->customer }}</div>
                                    </td>
                                    <!-- Patient -->
                                    <td class="table-text">
                                        <div>{{ $sched->patient }}</div>
                                    </td>
                                    <!-- Name -->
                                    <td class="table-text">
                                        <div>{{ $sched->patName }}</div>
                                    </td>
                                    <!-- Dispensing Date -->
                                    <td class="table-text">
                                        <div>{{ $sched->date_dispensed }}</div>
                                    </td>
                                    <!-- Quantity -->
                                    <td class="table-text">
                                        <div>{{ number_format($sched->qty, 2) }}</div>
                                    </td>
                                    <!-- Balance -->
                                    <td class="table-text">
                                        <div>{{ number_format($sched->balance, 2) }}</div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                            @else
                            <div class="alert alert-info" role="alert">No Scheduled Drugs to display</div>
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection

    @push('plugin-scripts')

    <script>
        var title = $('#reportHeader').html();
   // var date = '{!! $date->format('d/m/Y') !!}';


    title = "Printed On Date: "+'{!! $date->format('d/m/Y') !!}' +" At: " +'{!! $date->format('H:m') !!}' +"\n" +"From: " +'{{ $sdate }}' +" to: " +'{{ $edate }}' +"\n" +"Warehouse name: " +'{!! $warehouse->name !!}' +"\n" +"Schedule From: " +'{!! $sSchedule !!}' +" To: " +'{!! $eSchedule !!}' ;
   //title = "Printed On Date: "+date + "\n" +"At" ;

// alert(title);

    $(document).ready(function() {
        var printCounter = 0;
    $('#datatable').DataTable( {

columnDefs: [ {
    targets: [ 0 ],
    orderData: [ 0, 1 ]
}, {
    targets: [ 1 ],
    orderData: [ 1, 0 ]
}, {
    targets: [ 4 ],
    orderData: [ 4, 0 ]
} ],
dom: 'lBfrtip',
buttons: [
            'copy',
            {
                extend: 'excel',
                messageTop: 'reportHeader',
                title: null
            },
            {
                extend: 'pdf',
                messageBottom: null,
                messageTop: title,
                title: "Scheduled Drugs (By Schedule) Report",
                extend: 'pdfHtml5',
                orientation: 'landscape',
                pageSize: 'LEGAL'
            }

        ]
} );
} );
    </script>

    @section('script')
    <!-- Required datatable js -->
    <script src="//cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css"></script>
    <script src="//cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>

    <script src="//code.jquery.com/jquery-3.5.1.js"></script>
    <script src="//cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

    @endsection

    @endpush
