<!-- app/views/reports/StockItemUsage.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Individual Stock Item Usage @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a
        href="{!!URL::route('IndividualStock')!!}">BACK</a></button> @endslot
@endcomponent

<!-- Create Stock Item Usage Form... -->

<div class="row">
    <div class="col-xl-12 grid-margin stretch-card ">
        <div class="card">

            <div class="card-body text-center">

                <div id="reportHeader">
                    <h6><strong>STOCK ITEM USAGE REPORT</strong></h6>
                    <h6>Stock Type: <strong>{{ $type->description }}</strong> :: For Item:
                        <strong>{{ $code->description }}</strong></h6>
                    <h6>Warehouse: <strong>{{ $warehouse->name }}</strong></h6>
                    <h6>Range From: <strong>{{ $start_date }} {{ $start_time }}</strong> To: <strong>{{ $end_date }}
                            {{ $end_time }}</strong></h6>
                </div>

                <div class="mt-4">

                    <table class="table table-striped" id="datatable">
                        <!-- Table Headings -->
                        <thead>
                            <th>WHS</th>
                            <th>Date</th>
                            <th>Time</th>
                            <th>User</th>
                            <th>Client</th>
                            <th>Invoice</th>
                            <th>QTY</th>
                            <th>Amount</th>
                            <th>Discount</th>
                        </thead>

                        <!-- Table Body -->
                        <tbody>

                            @foreach ($stockItem as $item)
                                <tr>
                                    <!-- Warehouse -->
                                    <td class="table-text">
                                        <div>{{ $item->warehouse }}</div>
                                    </td>

                                    <!-- Datee -->
                                    <td class="table-text">
                                        <div>{{ $item->usage_date }}</div>
                                    </td>

                                    <!-- Time -->
                                    <td class="table-text">
                                        <div>{{ $item->usage_time }}</div>
                                    </td>

                                    <!-- User -->
                                    <td class="table-text">
                                        <div>{{ $item->user }}</div>
                                    </td>

                                    <!-- Client -->
                                    <td class="table-text">
                                        <div>{{ $item->client }}</div>
                                    </td>

                                    <!-- Invoice -->
                                    <td class="table-text">
                                        <div>{{ $item->invoice }}</div>
                                    </td>

                                    <!-- QTY -->
                                    <td class="table-text">
                                        <div>{{ $item->qty }}</div>
                                    </td>

                                    <!-- Amount -->
                                    <td class="table-text">
                                        <div>{{ number_format($item->amount, 2) }}</div>
                                    </td>

                                    <!-- Discount -->
                                    <td class="table-text">
                                        <div>{{ $item->discount }}</div>
                                    </td>
                                </tr>
                            @endforeach
                            <tfoot></tfoot>
                            <tfoot>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th>Total</th>
                                <th></th>
                                <th>{{ number_format($tot_qty, 2) }}</th>
                                <th>{{ number_format($tot_amount, 2) }}</th>
                                <th>{{ number_format($tot_discount, 2) }}</th>
                            </tfoot>
                            <tfoot>
                                <th>V.A.T. on Items:</th>
                                <th>{{ number_format($vat, 2) }}</th>
                            </tfoot>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('plugin-scripts')
<script>
    $(document).ready(function() {

    $('#datatable').DataTable( {

        "initComplete": function (settings, json) {
    $("#datatable").wrap("<div style='overflow:auto; width:100%;position:relative;'></div>");
  },

        paging: true,
        responsive: false,
        columnDefs: [ {
            targets: [ 0 ],
            orderData: [ 0, 1 ]
        }, {
            targets: [ 1 ],
            orderData: [ 1, 0 ]
        }, {
            targets: [ 4 ],
            orderData: [ 4, 0 ]
        } ],

        dom: 'lBfrtip',
        buttons: [
            'copy',
            {
                extend: 'excel',
                messageTop: 'reportHeader',
                title: null,
            },
            {
                extend: 'pdfHtml5',
                messageBottom: null,
                messageTop: 'title',
                title: "Debtors Age Analysis Report",
                orientation: 'landscape',
                pageSize: 'LEGAL'
            },

        ]

    } );
} );

</script>

@section('script')
<!-- Required datatable js -->
<!-- <script src="//cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css"></script>  remove this b/c giving { error-->

<!--<script src="//code.jquery.com/jquery-3.5.1.js"></script>  remove this b/c breaking menu -->
<script src="//cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/rowreorder/1.2.8/js/dataTables.rowReorder.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

@endsection

@endpush
