<!-- app/views/reports/TransactionTimelineReport.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Transaction Timeline Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a
        href="{!!URL::route('TransactionTimeline')!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- Create Transaction Timeline Report Form... -->

    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">

                <div class="card-body text-center">

                    <div id="reportHeader">

                        <h6>For Branch: <strong>{{ $branch_name }}</strong></h6>
                        <h6>For Period: <strong>{{ $sDate }}</strong> To: <strong>{{ $eDate }}</strong></h6>
                        <h6>Printed on: <strong>{{ $date->format('d/m/Y') }}</strong></h6>

                    </div>

                    <div class="mt-4">

                        <table class="table table-striped" id="datatable">
                            @foreach($vetUsers as $vetUser)
                                <thead>
                                    <th>User: <strong>{{ $vetUser->user_name }}</strong></th>
                                </thead>
                                <!-- Table Headings -->
                                <thead>
                                    <th>Type</th>
                                    <th>Dept</th>
                                    <th>Doc</th>
                                    <th>Date</th>
                                    <th>Time</th>
                                    <th>Secs</th>
                                </thead>

                                <!-- Table Body -->
                                <tbody>
                                    @foreach ($timelineArray as $timeline)
                                        @if($timeline->rep != $vetUser->rep or $timeline->time != $vetUser->t_time)
                                            @continue
                                        @endif
                                        <tr>
                                            <! -- Type -->
                                            <td class="table-text">
                                                <div>{{ $timeline->type }}</div>
                                            </td>

                                            <! -- Dept -->
                                            <td class="table-text">
                                                <div>{{ $timeline->dept }}</div>
                                            </td>

                                            <! -- Doc -->
                                            <td class="table-text">
                                                <div>{{ $timeline->doc }}</div>
                                            </td>

                                            <! -- Date -->
                                            <td class="table-text">
                                                <div>{{ $timeline->date }}</div>
                                            </td>

                                            <! -- Time -->
                                            <td class="table-text">
                                                <div>{{ $timeline->time }}</div>
                                            </td>

                                            <! -- Secs -->
                                            <td class="table-text">
                                                <div>{{ $timeline->secs }}</div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="table-text">
                                                <div>{{ $timeline->ref }}</div>
                                            </td>

                                            <! -- Customer -->
                                            <td class="table-text">
                                                <div>{{ $timeline->customer }}</div>
                                            </td>

                                            <! -- Client Name -->
                                            <td class="table-text">
                                                <div>{{ $timeline->name }}</div>
                                            </td>

                                            <! -- Stock -->
                                            <td class="table-text">
                                                <div>{{ $timeline->stock }}</div>
                                            </td>

                                            <! -- Amount -->
                                            <td class="table-text">
                                                <div>{{ $timeline->amount }}</div>
                                            </td>
                                        </tr>
                                    @endforeach
                                    <tfoot></tfoot>
                                    <tfoot>
                                        <th>End of User:</th>
                                        <th>{{  $vetUser->rep }}</th>
                                        <th>{{ $vetUser->amount }}</th>
                                    </tfoot>
                                </tbody>
                            @endforeach
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection
    @push('plugin-scripts')
    <script>
        $(document).ready(function() {

            $('#datatable').DataTable( {

                "initComplete": function (settings, json) {
            $("#datatable").wrap("<div style='overflow:auto; width:100%;position:relative;'></div>");
            },

                paging: true,
                responsive: false,
                columnDefs: [ {
                    targets: [ 0 ],
                    orderData: [ 0, 1 ]
                }, {
                    targets: [ 1 ],
                    orderData: [ 1, 0 ]
                }, {
                    targets: [ 4 ],
                    orderData: [ 4, 0 ]
                } ],

                dom: 'lBfrtip',
                buttons: [
                    'copy',
                    {
                        extend: 'excel',
                        messageTop: 'reportHeader',
                        title: null,
                    },
                    {
                        extend: 'pdfHtml5',
                        messageBottom: null,
                        messageTop: title,
                        title: "Debtors Age Analysis Report",
                        orientation: 'landscape',
                        pageSize: 'LEGAL'
                    },

                ]

            } );
            } );

    </script>

    @section('script')

    <script src="//cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/rowreorder/1.2.8/js/dataTables.rowReorder.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

    @endsection

    @endpush
