<!-- app/views/reports/UserSalesReport.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') User Sales Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a
        href="{!!URL::route('UserSales')!!}">BACK</a></button>
@endslot
@endcomponent
<!-- List User Sales Report Form... -->

<div class="row">
    <div class="col-xl-12 grid-margin stretch-card ">
        <div class="card">

            <div class="card-body text-center">

                <div id="reportHeader">
                    <h6>{{ $profitability }} <strong>{{ $start_date }}</strong> To: <strong>{{ $end_date }}</strong></h6>
                    <h6>Report Date: <strong>{{ $date->format('d/m/Y') }}</strong> Time:
                        <strong>{{ $date->format('H:m') }}</strong></h6>
                    <h6><strong>{{ $report }}</strong></h6>
                </div>

                <div class="mt-4">

                    <table class="table table-striped display nowrap" id="datatable" style="width:100%">
                        @if (count($salesReport) > 0)
                            @foreach($branchArray as $branch)
                                @if($branch->branch_id == 'A')
                                    @continue
                                @endif
                                <thead>
                                    <th>Branch : {{ $branch->branch_name }}</th>
                                </thead>
                                @foreach($vetArray as $vet)
                                    @if($vet->branch_id != $branch->branch_id)
                                        @continue
                                    @endif
                                    <thead>
                                        <th>Report for User : {{ $vet->vet_name }}</th>
                                    </thead>
                                    <!-- Table Headings -->
                                    <thead>
                                        <th>Description</th>
                                        <th>Amount</th>
                                        <th>Discount</th>
                                        <th>C.O.S</th>
                                        <th>Gross</th>
                                        <th>Adjust</th>
                                        <th>Net</th>
                                        <th>VAT</th>
                                    </thead>

                                    <!-- Table Body -->
                                    <tbody>
                                    @foreach ($salesReport as $sales)
                                        @if($sales->vet != $vet->vet_code)
                                            @continue
                                        @endif
                                        <tr>
                                            <!-- Description -->
                                            <td class="table-text">
                                                <div>{{ $sales->type }}</div>
                                            </td>
                                            <!-- Amount -->
                                            <td class="table-text">
                                                <div>{{ number_format($sales->amount, 2) }}</div>
                                            </td>
                                            <!-- Discount -->
                                            <td class="table-text">
                                                <div>{{ number_format($sales->discount, 2) }}</div>
                                            </td>
                                            <!-- Cost -->
                                            <td class="table-text">
                                                <div>{{ number_format($sales->cost, 2) }}</div>
                                            </td>
                                            <!-- Gross -->
                                            <td class="table-text">
                                                <div>{{ number_format($sales->gross, 2) }}</div>
                                            </td>
                                            <!-- Adjust -->
                                            <td class="table-text">
                                                <div>{{ number_format($sales->adjust, 2) }}</div>
                                            </td>
                                            <!-- Net -->
                                            <td class="table-text">
                                                <div>{{ number_format($sales->net, 2) }}</div>
                                            </td>
                                            <!-- VAT -->
                                            <td class="table-text">
                                                <div>{{ number_format($sales->VAT, 2) }}</div>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                    <tfoot></tfoot>
                                    <tfoot>
                                        <th>Vet Total</th>
                                        <th>{{ number_format($vet->vet_amt, 2) }}</th>
                                        <th>{{ number_format($vet->vet_discount, 2) }}</th>
                                        <th>{{ number_format($vet->vet_cost, 2) }}</th>
                                        <th>{{ number_format($vet->vet_gross, 2) }}</th>
                                        <th>{{ number_format($vet->vet_adjust, 2) }}</th>
                                        <th>{{ number_format($vet->vet_net, 2) }}</th>
                                        <th>{{ number_format($vet->vet_vat, 2) }}</th>
                                    </tfoot>
                                @endforeach
                                <tfoot></tfoot>
                                <tfoot>
                                    <th>Branch Total</th>
                                    <th>{{ number_format($branch->branch_amt, 2) }}</th>
                                    <th>{{ number_format($branch->branch_discount, 2) }}</th>
                                    <th>{{ number_format($branch->branch_cost, 2) }}</th>
                                    <th>{{ number_format($branch->branch_gross, 2) }}</th>
                                    <th>{{ number_format($branch->branch_adjust, 2) }}</th>
                                    <th>{{ number_format($branch->branch_net, 2) }}</th>
                                    <th>{{ number_format($branch->branch_vat, 2) }}</th>
                                </tfoot>
                            @endforeach
                            <tfoot></tfoot>
                            <tfoot>
                                <th>Grand Totals</th>
                                <th>{{ number_format($grand_amt, 2) }}</th>
                                <th>{{ number_format($grand_discount, 2) }}</th>
                                <th>{{ number_format($grand_cost, 2) }}</th>
                                <th>{{ number_format($grand_gross, 2) }}</th>
                                <th>{{ number_format($grand_adjust, 2) }}</th>
                                <th>{{ number_format($grand_net, 2) }}</th>
                                <th>{{ number_format($grand_vat, 2) }}</th>
                            </tfoot>
                            <thead>
                                <th>Summary</th>
                            </thead>
                            <thead>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th>Figures</th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th>Percentages</th>
                            </thead>
                            <thead>
                                <th>Description</th>
                                <th>Amt</th>
                                <th>Dis</th>
                                <th>Coss</th>
                                <th>Gross</th>
                                <th>Adj</th>
                                <th>Net</th>
                                <th>Amt</th>
                                <th>Dis</th>
                                <th>Coss</th>
                                <th>Gross</th>
                                <th>Adj</th>
                                <th>Net</th>
                            </thead>
                            @foreach ($salesBranchReport as $sales)
                                <tr>
                                    <!-- Description -->
                                    <td class="table-text">
                                        <div>{{ $sales->type }}</div>
                                    </td>
                                    <!-- Amount -->
                                    <td class="table-text">
                                        <div>{{ number_format($sales->amount, 2) }}</div>
                                    </td>
                                    <!-- Discount -->
                                    <td class="table-text">
                                        <div>{{ number_format($sales->discount, 2) }}</div>
                                    </td>
                                    <!-- Cost -->
                                    <td class="table-text">
                                        <div>{{ number_format($sales->cost, 2) }}</div>
                                    </td>
                                    <!-- Gross -->
                                    <td class="table-text">
                                        <div>{{ number_format($sales->gross, 2) }}</div>
                                    </td>
                                    <!-- Adjust -->
                                    <td class="table-text">
                                        <div>{{ number_format($sales->adjust, 2) }}</div>
                                    </td>
                                    <!-- Net -->
                                    <td class="table-text">
                                        <div>{{ number_format($sales->net, 2) }}</div>
                                    </td>
                                    <!-- Amount -->
                                    <td class="table-text">
                                        <div>{{ number_format(($sales->amount / $grand_amt * 100), 2) }}</div>
                                    </td>
                                    <!-- Discount -->
                                    @if($grand_discount != 0)
                                        <td class="table-text">
                                            <div>{{ number_format(($sales->discount / $grand_discount * 100), 2) }}</div>
                                        </td>
                                    @else
                                        <td class="table-text">
                                            <div>{{ number_format($sales->discount, 2) }}</div>
                                        </td>
                                    @endif
                                    <!-- Cost -->
                                    <td class="table-text">
                                        <div>{{ number_format(($sales->cost / $grand_cost * 100), 2) }}</div>
                                    </td>
                                    <!-- Gross -->
                                    <td class="table-text">
                                        <div>{{ number_format(($sales->gross / $grand_gross * 100), 2) }}</div>
                                    </td>
                                    <!-- Adjust -->
                                    @if($grand_adjust != 0)
                                        <td class="table-text">
                                            <div>{{ number_format(($sales->adjust / $grand_adjust * 100), 2) }}</div>
                                        </td>
                                    @else
                                        <td class="table-text">
                                            <div>{{ number_format($sales->adjust, 2) }}</div>
                                        </td>
                                    @endif
                                    <!-- Net -->
                                    <td class="table-text">
                                        <div>{{ number_format(($sales->net / $grand_net * 100), 2) }}</div>
                                    </td>
                                </tr>
                            @endforeach
                            <tfoot></tfoot>
                            <tfoot>
                                <th>Totals</th>
                                <th>{{ number_format($grand_amt, 2) }}</th>
                                <th>{{ number_format($grand_discount, 2) }}</th>
                                <th>{{ number_format($grand_cost, 2) }}</th>
                                <th>{{ number_format($grand_gross, 2) }}</th>
                                <th>{{ number_format($grand_adjust, 2) }}</th>
                                <th>{{ number_format($grand_net, 2) }}</th>
                            </tfoot>
                        @else
                            <div class="alert alert-info" role="alert">No User Sales to display</div>
                        @endif
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('plugin-scripts')

<script>
    var title = $('#reportHeader').html();

title = '{!! $profitability !!} ' +'{!! $start_date !!}' +" to: " +'{!! $end_date !!}'
+"\n" +"Report Date: " +'{!! $date->format('d/m/Y') !!}' +" Time: " +'{!! $date->format('H:m') !!}';

    $(document).ready(function() {
        var printCounter = 0;
    $('#datatable').DataTable( {

columnDefs: [ {
    targets: [ 0 ],
    orderData: [ 0, 1 ]
}, {
    targets: [ 1 ],
    orderData: [ 1, 0 ]
}, {
    targets: [ 4 ],
    orderData: [ 4, 0 ]
} ],
dom: 'lBfrtip',
buttons: [
            'copy',
            {
                extend: 'excel',
                messageTop: 'reportHeader',
                title: null
            },
            {
                extend: 'pdf',
                messageBottom: null,
                messageTop: title,
                title: "User Sales Report",
                extend: 'pdfHtml5',
                orientation: 'landscape',
                pageSize: 'LEGAL'
            }
        ]
} );
} );
</script>

@section('script')

<script src="//cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>

<script src="//cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

@endsection

@endpush
