<!-- app/views/user/edit.blade.php -->

@extends('layout/app')

@section('content')
<!-- Edit User Form... -->

<div class="page-content d-flex align-items-center justify-content-center">

    <div class="row w-100 mr-5 auth-page">
        <div class="col-md-8 col-xl-6 mx-auto">
            <div class="card">
                <div class="card-body">

                    <h4 class="mb-3">Update User: {!! $user->name !!} {!! $user->surname !!}</h4>

                    <!-- if there are creation errors, they will show here -->
                    {!! HTML::ul($errors->all()) !!}

                    {!! Form::model($user, ['method' => 'PATCH', 'route' => ['updateUser', $user->id]]) !!}

                    <div class="col-md-8">

                        <div class="form-group form-group-sm">
                            {!! Form::label('name', 'Name:') !!}
                            {!! Form::text('name', $user->name, array('class' => 'form-control input-sm
                            form-control-sm', 'required')) !!}
                        </div>

                        <div class="form-group form-group-sm">
                            {!! Form::label('surname', 'Surname:') !!}
                            {!! Form::text('surname', $user->surname, array('class' => 'form-control input-sm
                            form-control-sm', 'required')) !!}
                        </div>

                        <div class="form-group form-group-sm">
                            {!! Form::label('eid_id', 'Enterprise ID:') !!}
                            <select class="form-control input-sm input-sm form-control-sm" required name="eid_id"
                                id="eid_id">
                                @foreach($eids as $eid)
                                @if($eid['id'] == $user['eid_id'])
                                <option value="{{$user['eid_id']}}" selected="{{$user['eid_id']}}">
                                    {{$eid['name']}}
                                </option>
                                @else
                                <option value="{{$eid->id}}">{{$eid->name}}</option>
                                @endif
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group form-group-sm">
                            {!! Form::label('email', 'Email:') !!}
                            {!! Form::email('email', $user->email, array('class' => 'form-control input-sm
                            form-control-sm', 'required')) !!}
                        </div>

                        <div class="form-group form-group-sm">
                            {!! Form::label('password', 'Password:') !!}
                            <input class='form-control input-sm form-control-sm' type="password" required
                                name="password" id="password" value="{!!$user->password !!}">
                        </div>


                        <a href="{!!URL::route('users')!!}" class="btn btn-sm btn-secondary" role="button">Cancel</a>
                        {!! Form::submit('Update', array('class' => 'btn btn-sm btn-primary')) !!}
                        {!! Form::close() !!}

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection
