<!-- app/views/user/add.blade.php -->



<?php $__env->startSection('content'); ?>
<!-- Create User Form... -->

<div class="page-content d-flex align-items-center justify-content-center">

    <div class="row w-100 mr-5 auth-page">
        <div class="col-md-8 col-xl-6 mx-auto">
            <div class="card">
                <div class="card-body">

                    <h4 class="mb-3">Create New User</h4>

                    <!-- if there are creation errors, they will show here -->

                    <?php echo HTML::ul($errors->all()); ?>

                    <?php echo Form::model(new App\Models\User, ['route' => ['storeUser']]); ?>


                    <div class="col-md-8">

                        <div class="form-group form-group-sm">
                            <?php echo Form::label('name', 'Name:'); ?>

                            <?php echo Form::text('name', Request::old('name'), array('class' => 'form-control form-control-sm
                            input-sm', 'required')); ?>

                        </div>

                        <div class="form-group form-group-sm">
                            <?php echo Form::label('surname', 'Surname:'); ?>

                            <?php echo Form::text('surname', Request::old('surname'), array('class' => 'form-control
                            form-control-sm
                            input-sm',
                            'required')); ?>

                        </div>

                        <div class="form-group form-group-sm">
                            <?php echo Form::label('eid_id', 'Enterprise ID:'); ?>

                            <select class="form-control form-control-sm
                            input-sm" required name="eid_id" id="eid_id">
                                <option value="">Select EID</option>
                                <?php $__currentLoopData = $eids; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $eid): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($eid->id); ?>"><?php echo e($eid->enterprise_id); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="form-group form-group-sm">
                            <?php echo Form::label('email', 'Email:'); ?>

                            <?php echo Form::email('email', Request::old('email'), array('class' => 'form-control
                            form-control-sm
                            input-sm',
                            'required')); ?>

                        </div>

                        <div class="form-group form-group-sm">
                            <?php echo Form::label('password', 'Password:'); ?>

                            <?php echo Form::password('password', array('class' => 'form-control form-control-sm
                            input-sm', 'required')); ?>

                        </div>

                        <?php if(auth()->guard()->check()): ?>
                        <a href="<?php echo URL::route('users'); ?>" class="btn btn-sm btn-secondary" role="button">Cancel</a>
                        <?php else: ?>
                        <a href="<?php echo URL::previous(); ?>" class="btn btn-sm btn-secondary" role="button">Back</a>
                        <?php endif; ?>
                        <?php echo Form::submit('Create', array('class' => 'btn btn-sm btn-info')); ?>

                        <?php echo Form::close(); ?>


                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/vetsoft/resources/views/user/create.blade.php ENDPATH**/ ?>