<!-- app/views/reports/SalesByType.blade.php -->

<?php $__env->startSection('title'); ?> Dashboard <?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php $__env->startComponent('components.breadcrumb'); ?>

<?php $__env->slot('title'); ?> Stock Sales Report <?php $__env->endSlot(); ?>
<?php $__env->slot('li_1'); ?> <?php $__env->endSlot(); ?>
<?php if (isset($__componentOriginal04b5c99f4b0ecb1ac8b6cea23cbf13f14c9909f0)): ?>
<?php $component = $__componentOriginal04b5c99f4b0ecb1ac8b6cea23cbf13f14c9909f0; ?>
<?php unset($__componentOriginal04b5c99f4b0ecb1ac8b6cea23cbf13f14c9909f0); ?>
<?php endif; ?>
<?php echo $__env->renderComponent(); ?>

<!-- Create Daily Tracker Search Form... -->
<div class="row">
    <div class="col-xl-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <?php echo HTML::ul($errors->all()); ?>


                <?php echo Form::open(array('route' => 'SalesReportByType', 'method'=>'GET','files'=>true)); ?>


                <div class="col-sm-8 col-md-8">

                    <div class="form-group">
                        <?php echo Form::Label('warehouse_id', 'Warehouse'); ?>

                        <select class="form-control input-sm form-control-sm" required name="warehouse_id"
                            id="warehouse_id">
                            <option disabled selected hidden>All Warehouses</option>
                            <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($warehouse->id); ?>" <?php if(old('warehouse_id')==$warehouse->id): ?>
                                selected="selected"<?php endif; ?>><?php echo e($warehouse->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="type_indicator" name="type_indicator">
                        <label for="type_indicator"> Report on All Stock Types</label><br>
                    </div>

                    <div class="form-group">
                        <?php echo Form::Label('type_id', 'Stock Type'); ?>

                        <select class="form-control input-sm form-control-sm" required name="type_id" id="type_id">
                            <option disabled selected hidden>Select Type</option>
                            <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type->id); ?>" <?php if(old('type_id')==$type->id): ?>
                                selected="selected"<?php endif; ?>><?php echo e($type->description); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <?php echo Form::label('start_date', 'Start Date'); ?>

                        <?php echo Form::date('start_date', Request::old('start_date'), array('class' => 'form-control input-sm
                        form-control-sm', 'required', 'id'=>'start_date')); ?>

                    </div>

                    <div class="form-group">
                        <?php echo Form::label('end_date', 'End Date'); ?>

                        <?php echo Form::date('end_date', Request::old('end_date'), array('class' => 'form-control input-sm
                        form-control-sm', 'required', 'id'=>'end_date')); ?>

                    </div>

                    <div class="form-group">
                        <?php echo Form::Label('supplier_id', 'Supplier'); ?>

                        <select class="form-control input-sm form-control-sm" required name="supplier_id"
                            id="supplier_id">
                            <option disabled selected hidden>No Supplier</option>
                            <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($supplier->id); ?>" <?php if(old('supplier_id')==$supplier->id): ?>
                                selected="selected"<?php endif; ?>><?php echo e($supplier->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <?php echo Form::Label('manufacturer', 'Manufacturer'); ?>

                        <select class="form-control input-sm form-control-sm" required name="manufacturer"
                            id="manufacturer">
                            <option disabled selected hidden>No Manufacturer</option>
                            <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($supplier->id); ?>" <?php if(old('manufacturer')==$supplier->id): ?>
                                selected="selected"<?php endif; ?>><?php echo e($supplier->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-12 col-md-12">
                    <?php echo Form::submit('Submit', array('class' => 'btn btn-sm btn-primary')); ?>

                </div>
                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/vetsoft/resources/views/reports/SalesByType.blade.php ENDPATH**/ ?>