<!-- app/views/layout/layout.blade.php -->

<!DOCTYPE html>
<html lang="en">

<head>

    <title><?php echo $__env->yieldContent('title'); ?> | Vetsoft - Reports</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php echo HTML::script(URL::to('/').'/jquery/jquery-1.12.4.js'); ?>

    <?php echo HTML::script(URL::to('/').'/jquery/jquery-ui-1.12.1/jquery-ui.min.js'); ?>

    <?php echo HTML::style(URL::to('/').'/jquery/jquery-ui-1.12.1/jquery-ui.min.css'); ?>


    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js" type="text/javascript"></script>

    <?php echo HTML::script(URL::to('/').'/DataTables/media/js/jquery.dataTables.js'); ?>

    <?php echo HTML::style(URL::to('/').'/DataTables/media/css/jquery.dataTables.min.css'); ?>


    <?php echo HTML::script(URL::to('/').'/DataTables/extensions/Buttons/js/dataTables.buttons.min.js'); ?>

    <?php echo HTML::script(URL::to('/').'/DataTables/extensions/Buttons/js/buttons.print.min.js'); ?>

    <?php echo HTML::style(URL::to('/').'/DataTables/extensions/Buttons/css/buttons.dataTables.min.css'); ?>

    <?php echo HTML::script(URL::to('/').'/DataTables/extensions/Buttons/js/buttons.html5.js'); ?>

    <?php echo HTML::script(URL::to('/').'/DataTables/extensions/Buttons/js/buttons.flash.js'); ?>


    <?php echo HTML::style(URL::to('/').'/bootstrap-select/css/bootstrap-select.css'); ?>

    <?php echo HTML::script(URL::to('/').'/bootstrap-select/js/bootstrap-select.js'); ?>


    <!-- hybrid code begin -->

    
    <link rel="shortcut icon" href="<?php echo e(asset('/bmVetsoftpaw.jpg')); ?>">



    <!-- plugin css -->
    <link href="<?php echo e(asset('assets/fonts/feather-font/css/iconfont.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/plugins/flag-icon-css/css/flag-icon.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/plugins/@mdi/css/materialdesignicons.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/plugins/perfect-scrollbar/perfect-scrollbar.css')); ?>" rel="stylesheet" />
    <!-- end plugin css -->

    <?php echo $__env->yieldPushContent('plugin-styles'); ?>

    <!-- common css -->
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/plugins/datatables-net/jquery.dataTables.js')); ?>">
    <link href="<?php echo e(asset('assets/plugins/datatables-net-bs4/dataTables.bootstrap4.js')); ?>">

    <!-- end common css -->

    <!-- Remix icon js-->

    <link href="<?php echo e(asset('assets/js/pages/remix-icons-list.js')); ?>">
    <script src="<?php echo e(asset('assets/js/pages/remix-icons-list.js')); ?>"></script>
    <link href="https://cdn.jsdelivr.net/npm/remixicon@2.5.0/fonts/remixicon.css" rel="stylesheet">

    <!-- spinner code -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <script src="https://code.jquery.com/jquery-1.9.1.min.js"></script>
    <!-- spinner code end-->

    <?php echo $__env->yieldPushContent('style'); ?>
    <!-- hybrid code end -->

    <!-- ============================================================== -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.2.4/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/modernizr/2.8.3/modernizr.js"></script>

    
    <script>
        $(window).load(function() {
            // Animate loader off screen
            $(".se-pre-con").fadeOut("slow");;
        });
    </script>
    <!-- ============================================================== -->


</head>

<!-- hybrid code begin -->

<?php $__env->startSection('body'); ?> <?php echo $__env->yieldSection(); ?>

<body data-sidebar="dark">
    <!-- Begin page -->
    <?php if(!Auth::guest()): ?>
    <div id="layout-wrapper">
        <?php echo $__env->make('layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make('layout.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->

        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">
                    <?php if( session()->has('success') ): ?>
                    <div class="alert alert-success alert-dismissable" role="alert"><?php echo e(session()->get('success')); ?>

                        <button type="button" class="close" data-dismiss="alert" aria-label="close">&times;</button>
                    </div>
                    <?php elseif( session()->has('warning') ): ?>
                    <div class="alert alert-warning alert-dismissable"><?php echo e(session()->get('warning')); ?></div>
                    <?php elseif( session()->has('info') ): ?>
                    <div class="alert alert-info alert-dismissable"><?php echo e(session()->get('info')); ?></div>
                    <?php elseif( session()->has('danger') ): ?>
                    <div class="alert alert-danger alert-dismissable"><?php echo e(session()->get('danger')); ?></div>
                    <?php endif; ?>
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
                <!-- container-fluid -->
            </div>
            <section id="loading">
                <div id="loading-content"></div>
            </section>
            <!-- End Page-content -->
            <?php echo $__env->make('layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <!-- end main content-->
        <div class="se-pre-con"></div>
        <!-- END layout-wrapper -->

        <!-- /Right-bar -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- JAVASCRIPT -->
        <?php echo $__env->make('layout.vendor-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <!-- base js -->

        <script src="<?php echo e(asset('assets/plugins/feather-icons/feather.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/plugins/perfect-scrollbar/perfect-scrollbar.min.js')); ?>"></script>
        <!-- end base js -->

        <!-- plugin js -->
        <?php echo $__env->yieldPushContent('plugin-scripts'); ?>
        <!-- end plugin js -->

        <!-- common js -->
        <script src="<?php echo e(asset('assets/js/template.js')); ?>"></script>

        <!-- end common js -->

        <?php echo $__env->yieldPushContent('custom-scripts'); ?>


        <?php echo $__env->yieldContent('css'); ?>
        <!-- Bootstrap Css -->
        <link href="<?php echo e(URL::asset('/assets/css/bootstrap.min.css')); ?>" id="bootstrap-style" rel="stylesheet"
            type="text/css" />
        <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" id="bootstrap-style" rel="stylesheet"
            type="text/css" />

        <!-- App Css-->
        <link href="<?php echo e(URL::asset('/assets/css/app.min.css')); ?>" id="app-style" rel="stylesheet" type="text/css" />

        <!-- hybrid code end -->

</body>
<script type='text/javascript'>
    //for editing codes on a selected type
        $("#type_id").on("change", function(e) { populateCodes(); })
        function populateCodes()
        {
            var val = $('#code_id').val();
            $('#code_id').find('option').remove().end();
            var type_id = $('#type_id option:selected').attr('value');
            var info = $.get("<?php echo e(url('ajax-type-code')); ?>"+"/"+type_id);
            info.done(function(data) {
                $('#code_id').append('<option value="">None</option>');
                $.each(data,function(index,codeObj){
                    $('#code_id').append('<option value="'+codeObj.id+'">'+codeObj.description+'</option>');
                });
                $('#code_id').val(val);
            });
            info.fail(function(){
            });
        }
        //for editing sub transaction on a selected transaction type
        $("#tran_type").on("change", function(e) { populateSubTrans(); })
        function populateSubTrans()
        {
            var val = $('#sub_tran').val();
            $('#sub_tran').find('option').remove().end();
            var tran_type = $('#tran_type option:selected').attr('value');
            var info = $.get("<?php echo e(url('ajax-tran-sub')); ?>"+"/"+tran_type);
            info.done(function(data) {
                $('#sub_tran').append('<option value="">None</option>');
                $.each(data,function(index,codeObj){
                    $('#sub_tran').append('<option value="'+codeObj.id+'">'+codeObj.description+'</option>');
                });
                $('#sub_tran').val(val);
            });
            info.fail(function(){
            });

        }

    //end for editing codes on a selected type



</script>


<script>

</script>

</html>
<?php /**PATH /var/www/html/vetsoft/resources/views/layout/layout.blade.php ENDPATH**/ ?>