<!-- app/views/reports/SalesReportByAll.blade.php -->

<?php $__env->startSection('title'); ?> Dashboard <?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('title'); ?> STOCK SALES (By System Type) REPORT <?php $__env->endSlot(); ?>
<?php $__env->slot('li_1'); ?> <button type="button" class="btn btn-sm btn-primary"><a href="<?php echo URL::route('SalesByType'); ?>">BACK</a>
    <?php $__env->endSlot(); ?>
    <?php if (isset($__componentOriginal04b5c99f4b0ecb1ac8b6cea23cbf13f14c9909f0)): ?>
<?php $component = $__componentOriginal04b5c99f4b0ecb1ac8b6cea23cbf13f14c9909f0; ?>
<?php unset($__componentOriginal04b5c99f4b0ecb1ac8b6cea23cbf13f14c9909f0); ?>
<?php endif; ?>
<?php echo $__env->renderComponent(); ?>
    <!-- List Stock Sales Report Form... -->
    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">
                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6>For Date Range:<strong><?php echo e($start_date); ?></strong> To: <strong><?php echo e($end_date); ?></strong></h6>
                        <h6>For Branches: <strong> <?php echo e($branch); ?></strong></h6>
                    </div>

                    <div class="mt-4">

                        <table class="table table-striped display" id="datatable" style="width:100%">
                            <?php if(count($sales) > 0): ?>
                            <?php $__currentLoopData = $typeTot; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <!-- Table Headings -->
                            <thead>
                                <th>STOCK TYPE: <strong><?php echo e($type->description); ?></strong></th>
                            </thead>
                            <thead>
                                <th>Item</th>
                                <th>Qty</th>
                                <th>Mass</th>
                                <th>Cost</th>
                                <th>Sales</th>
                                <th>Discount</th>
                                <th>Profit</th>
                            </thead>

                            <?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($sale->type_id != $type->id): ?>
                            <?php continue; ?>
                            <?php endif; ?>

                            <!-- Table Body -->
                            <tbody>
                                <tr>
                                    <!-- Stock Type -->
                                    <td class="table-text">
                                        <div><?php echo e($sale->ref); ?></div>
                                    </td>
                                    <!-- Quantity -->
                                    <td class="table-text">
                                        <div><?php echo e(number_format($sale->qty, 2)); ?></div>
                                    </td>
                                    <!-- Mass -->
                                    <td class="table-text">
                                        <div><?php echo e(number_format($sale->mass, 2)); ?></div>
                                    </td>
                                    <!-- Cost -->
                                    <td class="table-text">
                                        <div><?php echo e(number_format($sale->cost, 2)); ?></div>
                                    </td>
                                    <!-- Sales -->
                                    <td class="table-text">
                                        <div><?php echo e(number_format($sale->sales, 2)); ?></div>
                                    </td>
                                    <!-- Discount -->
                                    <td class="table-text">
                                        <div><?php echo e(number_format($sale->discount, 2)); ?></div>
                                    </td>
                                    <!-- Profit -->
                                    <td class="table-text">
                                        <div><?php echo e(number_format($sale->profit, 2)); ?></div>
                                    </td>
                                </tr>
                            </tbody>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tfoot></tfoot>
                            <tfoot>
                                <tr>
                                    <th></th>
                                    <th>QTY</th>
                                    <th>Mass</th>
                                    <th>Cost</th>
                                    <th>Sales</th>
                                    <th>Discount</th>
                                    <th>Profit</th>
                                </tr>
                            </tfoot>
                            <tfoot>
                                <tr>
                                    <th><strong>Sub Total</strong></th>
                                    <th><?php echo e(number_format($type->qty, 2)); ?></th>
                                    <th><?php echo e(number_format($type->mass, 2)); ?></th>
                                    <th><?php echo e(number_format($type->cost, 2)); ?></th>
                                    <th><?php echo e(number_format($type->sales, 2)); ?></th>
                                    <th><?php echo e(number_format($type->discount, 2)); ?></th>
                                    <th><?php echo e(number_format($type->profit, 2)); ?></th>
                                </tr>
                            </tfoot>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tfoot>
                                <tr>
                                    <th><strong>Grand Total</strong></th>
                                    <th><?php echo e(number_format($qty_tot, 2)); ?></th>
                                    <th><?php echo e(number_format($mass_tot, 2)); ?></th>
                                    <th><?php echo e(number_format($cost_tot, 2)); ?></th>
                                    <th><?php echo e(number_format($sales_tot, 2)); ?></th>
                                    <th><?php echo e(number_format($discount_tot, 2)); ?></th>
                                    <th><?php echo e(number_format($profit_tot, 2)); ?></th>
                                </tr>
                            </tfoot>
                            <?php else: ?>
                            <div class="alert alert-info" role="alert">No Sales are available</div>
                            <?php endif; ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->stopSection(); ?>

    <?php $__env->startPush('plugin-scripts'); ?>

    <script>
        var title = $('#reportHeader').html();

    title = "For Date Range: " +'<?php echo $start_date; ?>' +" To: " +'<?php echo $end_date; ?>'
            +"\n" +"For Branches: "+'<?php echo $branch; ?>';

    $(document).ready(function() {
        var printCounter = 0;
        $('#datatable').DataTable( {

            columnDefs: [ {
                targets: [ 0 ],
                orderData: [ 0, 1 ]
            }, {
                targets: [ 1 ],
                orderData: [ 1, 0 ]
            }, {
                targets: [ 4 ],
                orderData: [ 4, 0 ]
            } ],
            dom: 'lBfrtip',
            buttons: [
                'copy',
                {
                    extend: 'excel',
                    messageTop: title,
                    title: null,
                },
                {
                    extend: 'pdfHtml5',
                    messageBottom: null,
                    messageTop: title,
                    title: "STOCK SALES (By System Type) REPORT",
                }
            ]
        } );
    } );
    </script>



    <?php $__env->startSection('script'); ?>
    <!-- Required datatable js -->
    <!-- <script src="//cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    </script> remove this b/c giving { error-->

    <!--<script src="//code.jquery.com/jquery-3.5.1.js"></script>  remove this b/c breaking menu -->
    <script src="//cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.1/js/buttons.print.min.js"></script>

    <?php $__env->stopSection(); ?>

    <?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/vetsoft/resources/views/reports/SalesReportByAll.blade.php ENDPATH**/ ?>